// server.js
const express = require('express');
const path = require('path');
const app = express();

const PORT = process.env.PORT || 4000; // 使用一个不常用的端口，避免冲突

// 关键：托管 build 目录下的静态文件
// __dirname 是当前文件（server.js）所在的目录
// path.join 用来正确地拼接路径
app.use(express.static(path.join(__dirname, 'build')));

// 对于所有其他的 GET 请求，都返回 index.html
// 这对于使用 React Router 的单页面应用（SPA）至关重要
app.get('/*', (req, res) => {
  res.sendFile(path.join(__dirname, 'frontend','build', 'index.html'));
});

app.listen(PORT, () => {
  console.log(`Server is running on http://localhost:${PORT}`);
  console.log('Press Ctrl+C to quit.');
  // 你可以在这里添加一个自动打开浏览器的功能
  // const open = require('open');
  // open(`http://localhost:${PORT}`);
});