# 展映 商业数据 AI 智慧经营 综合用户手册

欢迎使用 展映 商业数据 AI 智慧经营！本手册是您的一站式指南，旨在帮助用户和管理员全面了解、高效使用并轻松维护 展映 商业数据 AI 智慧经营 平台。

---

## 目录

*   [**第 1 章：产品简介**](#chapter-1)
    *   [1.1 什么是 商业数据 AI 智慧经营？](#1.1)
    *   [1.2 产品愿景](#1.2)
    *   [1.3 为谁而设计？](#1.3)
*   [**第 2 章：用户使用指南**](#chapter-2)
    *   [2.1 快速入门](#2.1)
    *   [2.2 核心功能详解](#2.2)
    *   [2.3 高级功能探索](#2.3)
        *   [2.3.4 深度报告功能](#2.3.4)
        *   [2.3.5 ESG 报告生成](#2.3.5)
*   [**第 3 章：管理员指南**](#chapter-3)
    *   [3.1 安装与部署](#3.1)
    *   [3.2 首次系统配置](#3.2)
    *   [3.3 数据源管理](#3.3)
    *   [3.4 用户与安全管理](#3.4)
    *   [3.5 知识库管理](#3.5)
    *   [3.6 系统参数配置](#3.6)
*   [**第 4 章：常见问题解答 (FAQ)**](#chapter-4)
*   [**第 5 章：术语表**](#chapter-5)
*   [**第 6 章：技术支持**](#chapter-6)

---

<a id="chapter-1"></a>
## 第 1 章：产品简介

<a id="1.1"></a>
### 1.1 什么是 商业数据 AI 智慧经营？

展映 商业数据 AI 智慧经营 是一款革命性的对话式商业智能平台，它允许从一线员工到高层决策者的所有用户，使用自然语言与企业数据直接对话，实现即时的数据查询、深度分析与洞察发现。

无需编写复杂的 SQL 查询或操作繁琐的 BI 工具，您只需像与数据分析师交谈一样提出问题，商业数据 AI 智慧经营 就能为您：
*   **自动理解业务问题**，并准确定位到相关的数据。
*   **生成高效的 SQL 查询**，并从数据库中获取数据。
*   **提供智能的数据可视化**，自动选择最合适的图表。
*   **支持多轮追问和下钻分析**，探索问题的根本原因。
*   **主动发现数据异常**，并提供分析洞察。

<a id="1.2"></a>
### 1.2 产品愿景

我们的愿景是打造一个自主的 AI 数据分析伙伴，通过一个统一的对话界面，连接企业所有数据，赋予每一位员工与数据进行深度、直观交互的能力，将数据驱动决策无缝融入组织的每个角落，最终提升整个组织的运营效率和战略敏捷性。

<a id="1.3"></a>
### 1.3 为谁而设计？

展映 ZY SmartBI 服务于企业中的每一位成员：

*   **业务决策者 (如部门经理)**: 无需等待数据团队的报告，可以即时获取决策所需的核心数据，快速响应市场变化。
    *   *“上个季度我们各区域的销售额达成率如何？”*
*   **一线运营/销售人员**: 能够轻松监控日常业务指标，在发现异常时能第一时间进行追问和溯源。
    *   *“今天上午的用户注册量有异常吗？为什么？”*
*   **数据分析师**: 从大量重复、临时的提数需求中解放出来，将宝贵的时间投入到更具价值的深度建模和复杂分析工作中。
*   **IT/系统管理员**: 通过统一的界面高效、安全地管理数据源连接、用户权限，并轻松监控系统使用情况。

---

<a id="chapter-2"></a>
## 第 2 章：用户使用指南

本章专为 ZY SmartBI 的日常使用者（如业务人员、运营、销售、市场等）编写。

<a id="2.1"></a>
### 2.1 快速入门

#### 1. 首次登录

1.  打开您的浏览器，访问 ZY SmartBI 的登录页面 (例如: `http://127.0.0.1:8000/login`)
2.  输入您的用户名和密码。如果是首次使用，您的管理员会提供初始凭据。
3.  点击“登录”按钮。

成功登录后，您将进入对话式分析主界面。建议您在首次登录后立即修改密码。

#### 2. 提出您的第一个问题

在聊天输入框中，用清晰、具体的自然语言输入您想了解的数据问题。

**提问示例：**
*   **简单查询**：“显示去年每个月的销售总额。”
*   **对比分析**：“对比一下A、B两个产品的利润率。”
*   **明细查询**：“列出所有活跃客户的姓名和他们的最近一次购买日期。”
*   **分析类问题**：“为什么上个月的用户增长率下降了？”
*   **异常检测**：“最近的数据有异常吗？”
*   **知识问答**：“什么是 GMV？”

输入问题后，按下回车键或点击发送按钮。

#### 3. 理解查询结果

系统会快速处理您的问题，并以多种形式展示结果：

1.  **SQL 生成与解释**：系统会将您的问题转换为 SQL 查询，并可能显示 SQL 语句以供参考。
2.  **数据表格**：以表格形式展示查询返回的原始数据。
3.  **数据可视化**：自动生成最合适的图表（如柱状图、折线图、饼图等），让数据一目了然。
4.  **分析洞察**：对于分析类问题，系统会提供结构化的分析结论和洞察摘要。

<a id="2.2"></a>
### 2.2 核心功能详解

#### 1. 多轮对话与上下文理解

ZY SmartBI 能够理解对话的上下文，您可以基于上一个问题继续追问，无需重复背景信息。

**示例：**
1.  **您：** “显示去年每个月的销售总额。”
2.  **ZY SmartBI：** (展示销售总额图表)
3.  **您：** “那利润呢？” (系统会自动理解您是在询问“去年每个月的利润总额”)
4.  **ZY SmartBI：** (展示利润总额图表)
5.  **您：** “只看华东地区的。” (系统会进一步筛选华东地区的利润数据)

#### 2. 数据可视化与交互

*   **自动图表推荐**：系统自动选择最适合的图表类型。
*   **切换图表类型**：您也可以手动从下拉菜单中选择其他图表类型（如柱状图、折线图、饼图、散点图等）。
*   **调整坐标轴/刻度**：您可以手动选择用于 X 轴和 Y 轴的字段，或更改 Y 轴的数值刻度（如线性、对数）。
*   **数据下钻 (Drill-down)**：通过追问的方式实现下钻。例如，在看到各地区销售额后，可以追问“详细看看华东地区的情况”。

#### 3. 仪表板 (Dashboards)

仪表板功能允许您将关键的图表和指标聚合到一个视图中，进行集中监控。

*   **查看仪表板**：从导航菜单访问“仪表板”列表，查看您有权访问的公共仪表板。
*   **创建与布局**：
    1.  点击“新建看板”，选择一个合适的布局模板（如瀑布流、驾驶舱）。
    2.  为看板命名，并向布局中添加“项目 (Item)”。
    3.  为每个项目关联一个“数据源 (Source)”（即一个可复用的命名查询）。
    4.  配置每个项目的标题、显示类型、图表细节等。
*   **发布与分享**：创建的仪表板默认为“草稿”状态，只有您自己可见。完成设计后，您可以将其“发布”，使其对组织内的其他用户可见（可能需要管理员权限）。

#### 4. 查询历史

系统会保存您所有的查询记录。您可以随时通过“查询历史”功能回顾、复用或修改之前的查询。

#### 5. 导出与分享

*   **导出数据**：轻松将查询结果的表格数据导出为 CSV 或 Excel 文件。
*   **导出图表**：将图表保存为图片文件（如 PNG）。
*   **分享链接**：为任何一次查询结果生成一个唯一的分享链接。拥有相应数据权限的用户可以通过链接查看结果。

<a id="2.3"></a>
### 2.3 高级功能探索

#### 1. 深度分析 (Analysis)

当您提出开放、复杂的分析性问题时，系统会自动启动深度分析功能。

**如何触发：**
*   “分析上个月销售额下降的根本原因。”
*   “探索不同用户群体的购买行为模式。”
*   “预测下个季度的产品销量趋势。”

系统会生成一份详细的分析报告，包含多维度的拆解、结论、图表和支持数据。

#### 2. 指标管理与监控 (Metrics & Monitoring)

您可以让系统主动跟踪关键业务指标的变化。

**如何配置：**
*   **通过对话配置**：“当‘活跃用户率’低于5%时通知我。”
*   **通过管理界面配置**：管理员可以配置更复杂的监控规则和通知渠道。

#### 3. 探索性与预测性分析

您可以提出探索性或假设性的问题，系统会利用其分析模型，根据现有数据进行推断和预测。

**示例：**
*   “探索一下高价值客户的主要特征是什么？”
*   “如果产品价格提高10%，对销售额可能有什么影响？” (What-if 模拟)

#### 4. 深度报告功能

##### 4.1. 功能概述

深度报告功能旨在帮助用户通过AI进行深入的市场、行业或特定主题研究，并生成结构化、内容丰富的报告。与传统的数据分析不同，深度报告能够整合外部网络信息，提供更全面的洞察。

##### 4.2. 运行流程

深度报告的生成遵循以下步骤：

1.  **意图识别**: 系统首先分析用户的输入，判断其是否为“深度报告”意图。
2.  **需求澄清（多轮交互）**: 如果是首次发起深度报告请求，AI会主动向用户提出3-5个澄清性问题，以帮助用户细化研究主题，确保报告的针对性。
3.  **研究规划**: 基于用户明确的研究主题和澄清问题的答案，AI会生成一个详细的研究计划，包括一系列需要执行的网络搜索任务。
4.  **信息执行**: AI根据研究计划，通过调用外部网络搜索API（如Serper），执行各项搜索任务，收集相关信息。
5.  **报告综合**: AI对收集到的所有信息进行筛选、整合、分析和推理，最终综合生成一份全面的深度研究报告。
6.  **保存与通知**: 生成的报告会自动保存到系统，并通知用户报告已完成。

##### 4.3. 如何触发深度报告

用户可以通过两种方式触发深度报告的生成：

##### 4.3.1. 对话式触发（推荐）

在ChatBI的聊天界面中，直接以自然语言提出您的研究需求。系统会根据您的提问自动识别为“深度报告”意图。

**示例**: 
*   “请帮我研究一下2025年全球电动汽车市场的竞争格局。”
*   “我需要一份关于人工智能在医疗领域应用前景的深度报告。”

系统识别意图后，会主动向您提出澄清问题，引导您提供更具体的需求。请根据提示逐一回答这些问题，以确保报告的质量和针对性。

##### 4.3.2. 手动触发（从深度报告页面）

您也可以直接访问“深度报告”管理页面，手动发起报告生成任务。

1.  登录ChatBI系统，进入管理后台。
2.  在左侧导航栏中，点击“深度报告”菜单项。
3.  在页面顶部的表单中，输入您的研究主题。
4.  点击“触发新报告”按钮。

**注意**: 通过此方式触发的报告将跳过多轮澄清问答环节，系统会直接根据您输入的标题进行研究。因此，请确保您输入的研究主题足够具体和明确。

#### 4.4. 查看深度报告

所有生成的深度报告都可以在“深度报告”管理页面中查看。

1.  登录ChatBI系统，进入管理后台。
2.  在左侧导航栏中，点击“深度报告”菜单项。
3.  页面会显示所有已生成的报告列表，包括报告ID、原始问题、生成时间等信息。
4.  点击报告旁边的“查看摘要”按钮，即可在弹窗中查看报告的简要内容。


---

<a id="chapter-3"></a>
## 第 3 章：管理员指南

本章专为 ZY SmartBI 的系统管理员编写，涵盖安装、配置、维护和安全管理。

<a id="3.1"></a>
### 3.1 安装与部署

请按照以下步骤在服务器环境中从零开始安装和部署 ZY SmartBI。

#### 1. 环境与软件包准备

*   **操作系统**: Windows 10 或更高版本。
*   **硬件**: 建议 4核 CPU, 8GB RAM, 50GB 可用磁盘空间。
*   **核心软件包**:
    *   **PostgreSQL**: 建议最新版本 (如 17.6)。
    *   **Python**: 建议 3.13.6 版本。
    *   您可以从官方网站下载，或使用我们提供的链接。请将下载的软件包放置在发布包的根目录下。

#### 2. 安装步骤

我们提供了一系列批处理脚本 (`.bat`) 来简化安装过程。

*   **步骤 1: 安装核心组件**
    *   双击运行 `安装 展映 AI 智慧经营.bat` 脚本，安装核心组件。
    *   双击运行 `安装python.bat` 脚本，安装 ZY SmartBI 所需的 Python 环境和依赖库。
    *   **重要**: 安装 PostgreSQL 后，请运行 `services.msc` 打开服务管理器，找到 `postgresql` 服务，并将其启动类型设置为“自动”。

*   **步骤 2: 创建数据库并配置环境变量 (`.env` 文件)**
    **重要：在配置环境变量前，请务必手动创建名为 `chatbi_forge_dev` 的数据库。**
    1.  在项目根目录下，找到 `.env.example` 文件，复制并重命名为 `.env`。
    2.  使用文本编辑器打开 `.env` 文件，并配置以下关键信息：
        *   **数据库连接 (用于存储 ZY SmartBI 自身元数据)**:
            ```env
            DB_USER=postgres
            DB_PASSWORD=ZYCBI2025 # 请修改为您的PostgreSQL密码
            DB_HOST=127.0.0.1
            DB_PORT=5432
            DB_NAME=chatbi_forge_dev
            ```
        *   **管理员账户 (首次启动时创建)**:
            ```env
            DEFAULT_ADMIN_USERNAME=admin
            DEFAULT_ADMIN_PASSWORD=admin1
            ```
        *   **调试登录 (可选)**:
            ```env
            # 设置为 True 可使用任意密码登录，仅限开发测试环境
            LOGIN_DEBUG=True 
            ```
        *   **LLM API 密钥 (至少配置一个)**:
            ```env
            DEEPSEEK_API_KEY=your_deepseek_api_key_here
            DASHSCOPE_API_KEY=your_dashscope_api_key_here
            ```

*   推荐使用 kimi k2 替代deepseek。

*   **步骤 3: 初始化数据（可以跳过，会自动初始化，如果需要重置数据库，可运此命令）**
    *   双击运行 `初始化数据.bat` 脚本。
    *   此脚本将连接到您在 `.env` 文件中配置的数据库，并创建 ZY SmartBI 所需的表结构和示例数据。

*   **步骤 4: 启动服务**
    *   双击运行 `运行 ZY chatBI.bat` 脚本。
    *   服务启动大约需要 40 秒。启动成功后，您可以通过浏览器访问系统。

#### 3. 访问系统

*   **用户登录**: `http://127.0.0.1:8000/login`
*   **对话界面**: `http://127.0.0.1:8000/chat`
*   **管理员界面**: `http://127.0.0.1:8000/admin/dashboard`

<a id="3.2"></a>
### 3.2 首次系统配置

系统首次运行后，请以管理员身份完成以下核心配置。

1.  **首次登录管理员账户**
    *   访问 `http://127.0.0.1:8000/login`。
    *   使用默认凭据登录 (用户名: `admin`, 密码: `admin1`)。
    *   登录后，强烈建议您立即导航到用户管理模块，修改默认管理员的密码。

2.  **连接第一个业务数据源**
    *   在管理界面，导航到“数据源管理”。
    *   点击“添加新数据源”，填写数据源的唯一名称、选择数据库类型并填入连接参数。
    *   点击“测试连接”验证配置，然后保存数据源。

3.  **导入并丰富元数据**
    *   导航至“元数据管理”页面，选择刚添加的数据源。
    *   点击“导入数据源元数据”按钮，将数据库的表和列信息录入系统。
    *   **（推荐）** 点击“AI 自动生成元数据”按钮，让 AI 自动为表和列生成业务描述、同义词等，这将极大提升后续自然语言转 SQL 的准确率。

4.  **创建第一个用户与角色**
    *   导航到“角色与权限管理”，创建一个新角色（例如 `Sales_Analyst`），并为该角色分配数据源的访问权限。
    *   导航到“用户管理”，创建一个新用户，并将其分配到 `Sales_Analyst` 角色。

<a id="3.3"></a>
### 3.3 数据源管理

#### 支持的数据源类型

ZY SmartBI 支持连接多种主流数据库，包括 POSTGRESQL, MYSQL, SQLSERVER, ORACLE, CLICKHOUSE, SNOWFLAKE, BIGQUERY 等（目前基础体验版本仅支持连接 POSTGRESQL, MYSQL, SQLSERVER 数据库。如需支持其他数据库类型，请联系我们获取标准版）。

#### 管理数据源

在“数据源管理”页面，您可以对已添加的数据源进行操作：
*   **添加**：连接新的业务数据库。
*   **编辑**：修改数据源的连接参数或名称。
*   **删除**：从 ZY SmartBI 中移除数据源的连接信息。
*   **刷新元数据**：当业务数据库结构发生变化时，需要重新导入元数据。

#### 高级元数据管理

在数据源的元数据管理页面，您可以使用 AI 增强功能：
*   **AI 生成描述与逻辑 (`Generate Metadata`)**：核心功能，利用 LLM 分析表结构和数据，自动填充业务描述、同义词，并生成“选择逻辑”以指导 AI 更智能地选择表。
*   **清除 AI 生成的描述 (`Clear Descriptions`)**：移除所有 AI 生成的描述和同义词。
*   **删除所有元数据 (`Delete All Metadata`)**：彻底删除此数据源在 ZY SmartBI 中的所有元数据记录，用于数据源结构发生重大变化后的重建。

<a id="3.4"></a>
### 3.4 用户与安全管理

#### 用户管理 (User Management)

在“用户管理”界面，您可以：
*   **创建新用户**：设置用户名、初始密码和状态。
*   **编辑用户**：修改用户信息，如重置密码、禁用账户。
*   **删除用户**：永久移除用户账户。

#### 角色管理 (RBAC - Role-Based Access Control)

ZY SmartBI 实现了基于角色的访问控制（RBAC）模型，通过将权限分配给角色，再将角色分配给用户，从而简化了用户权限的管理。角色是权限的集合，通过“角色 -> 用户”的模式简化权限管理。
*   **创建新角色**：定义角色名称（如 `Sales_Analyst`, `HR_Viewer`）。
*   **分配权限**：为角色分配可访问的**数据源**和可使用的**功能**。
*   **为用户分配角色**：在用户编辑页面，为用户选择一个或多个角色。

#### 数据权限控制 (RLS & CLS)

为了确保数据安全和隐私，ZY SmartBI 提供了强大的行级安全（RLS）和列级安全（CLS）功能，允许管理员精细控制用户对数据的访问权限。

*   **行级安全 (Row-Level Security, RLS)**: 限制用户只能访问表中的特定行。例如，销售经理只能看到自己团队的销售数据。
*   **列级安全 (Column-Level Security, CLS)**: 限制用户只能访问表中的特定列。例如，非 HR 用户无法看到薪资列。
*   RLS 和 CLS 策略是高级功能，通常在角色权限配置中，为特定数据表定义行过滤条件或指定可访问的列列表。

#### PII 数据脱敏

为保护敏感数据，系统内置了 PII (个人身份信息) 脱敏功能。
*   **启用/禁用**：可在系统配置中全局启用 `PII_SCRUBBING_ENABLED`。
*   **配置规则**：管理员可在后台配置 PII 识别规则（如通过正则表达式定义邮箱、电话号码等模式）。

#### 审计日志

系统会记录用户的关键操作（如登录、查询、配置更改）和系统事件。管理员可在“审计日志”模块查看这些记录，用于安全审计和问题追踪。

<a id="3.5"></a>
### 3.5 知识库管理

知识库是 ZY SmartBI RAG (检索增强生成) 服务的重要组成部分，它为 LLM 提供额外的业务上下文，以提高查询的准确性。

#### 什么是知识库？

知识库可以包含：
*   **业务规则**：特定指标的计算逻辑、业务流程说明。
*   **数据字典**：对表和列的更详细业务解释。
*   **历史查询示例**：成功的“问题-SQL”配对，作为 AI 的学习样本。
*   **其他文档**：产品手册、FAQ、公司报告等。

#### 管理知识库

1.  **配置知识库源文件目录**：将知识文档（支持 Markdown, TXT, PDF 等）存放在服务器的特定目录下，并在管理界面中添加该目录作为知识源。
2.  **知识库索引**：添加或修改源文件后，需要触发“索引”操作。系统会扫描文件，将其处理成向量并存入向量数据库。此操作可在管理界面手动触发。
3.  **维护**：
    *   **清空知识库**：删除向量数据库中所有已索引的文档。
    *   **删除单个文档**：根据文档 ID 移除特定的已索引文件。

<a id="3.6"></a>
### 3.6 系统参数配置

ZY SmartBI 采用分层配置，**数据库配置 (通过管理界面设置) 的优先级高于环境变量 (`.env` 文件)**。通过管理界面修改的配置可即时生效。

#### 通过管理界面配置 (推荐)

*   **访问路径**：`管理` -> `系统设置`。
*   **可配置项**：
    *   **AI 提供商设置**：管理各大模型服务的 API 密钥和 Base URL。
    *   **系统提示模板**：自定义系统在不同场景下（如知识问答、澄清问题、回退）与 LLM 交互时使用的提示词模板。

#### 通过 .env 文件配置 (备用/初始)

修改 `.env` 文件后，**必须重启服务**才能生效。

*   **数据库配置 (`DB_*`)**: ZY SmartBI 内部元数据数据库的连接信息。
*   **向量数据库 (`VECTOR_STORE_PATH`)**: ChromaDB 向量数据库的存储路径。
*   **LLM 服务配置 (`OPENAI_API_KEY`, `LLM_TEMPERATURE` 等)**: 配置各大模型服务的 API Key、模型名称、温度等参数。
*   **安全与隐私 (`SECRET_KEY`, `LOGIN_DEBUG`, `PII_SCRUBBING_ENABLED`)**: 配置安全密钥、调试模式和 PII 脱敏开关。
*   **日志与监控 (`LOG_LEVEL`, `LOG_FILE_PATH`)**: 配置日志级别和输出文件路径。
*   **其他 (`MAX_CONCURRENT_QUERIES`, `MAX_CONVERSATION_HISTORY_MESSAGES` 等)**: 配置并发查询数、对话历史长度等性能和功能参数。

---

<a id="chapter-4"></a>
## 第 4 章：常见问题解答 (FAQ)

### 登录与账户
*   **Q: 我忘记了密码怎么办？**
    *   **A:** 请联系您的系统管理员重置密码。
*   **Q: 为什么我无法登录，提示“账户被锁定”？**
    *   **A:** 多次输入错误密码会导致账户被暂时锁定。请等待一段时间后重试，或联系管理员解锁。

### 查询与数据
*   **Q: 为什么我的查询结果是空的？**
    *   **A:** 可能原因包括：数据本身不存在、您没有访问该数据的权限、提问过于模糊、或后端数据源连接有问题。请逐一排查或联系管理员。
*   **Q: 为什么我的查询速度很慢？**
    *   **A:** 查询速度受数据量、查询复杂度、数据库性能和系统当前负载等多种因素影响。
*   **Q: 系统无法理解我的问题怎么办？**
    *   **A:** 尝试简化问题、使用更标准的业务术语、提供更多上下文或检查错别字。

### 报表与可视化
*   **Q: 我能自定义图表吗？**
    *   **A:** 可以。在图表生成后，您通常可以切换图表类型、调整 X/Y 轴字段、更改刻度等，以满足您的个性化分析需求。

---
<a id="chapter-5"></a>
## 第 5 章：术语表

### 业务术语
*   **维度 (Dimension)**: 分析数据的视角，通常是文本类型，如“地区”、“产品类别”。
*   **指标 (Metric)**: 用于衡量业务表现的数值，通常是数字类型，如“销售额”、“订单量”。
*   **洞察 (Insight)**: 从数据中发现的有价值、可行动的结论。
*   **下钻 (Drill-down)**: 从宏观数据深入到更细粒度的微观数据的分析过程。
*   **根因分析 (Root Cause Analysis, RCA)**: 找出导致某一现象（如指标下降）的根本原因。

### 技术术语
*   **LLM (Large Language Model)**: 大型语言模型，是驱动 ZY SmartBI 理解和生成语言的 AI 核心。
*   **RAG (Retrieval-Augmented Generation)**: 检索增强生成。系统在回答问题前，先从知识库中检索相关信息，再结合这些信息生成更准确的答案。
*   **元数据 (Metadata)**: “关于数据的数据”，包括表名、列名、数据类型、业务描述等，是 ZY SmartBI 理解您数据结构的基础。
*   **PII (Personally Identifiable Information)**: 个人身份信息，如姓名、电话、邮箱等敏感数据。
*   **RBAC (Role-Based Access Control)**: 基于角色的访问控制，一种高效管理用户权限的安全模型。

---

<a id="chapter-6"></a>
## 第 6 章：技术支持

如果您在使用过程中遇到任何问题或有任何建议，请通过以下方式联系我们：

*   **公司名称**: 深圳展映科技有限公司
*   **官方网站**: zyinfo.pro
*   **微信联系**: youkpan
*   **技术支持邮箱**: pyq@zyinfo.pro

感谢您选择 展映 ZY SmartBI，让我们一起开启数据驱动决策的新时代！

