# ZY SmartBI 业务术语表

本术语表旨在解释 ZY SmartBI 平台中常用的一些业务和技术术语，帮助用户更好地理解系统功能和数据分析概念。

---

## 业务相关术语

### 维度 (Dimension)

*   **定义**：用于描述、分类或分组数据的属性。维度通常是定性的，例如“产品名称”、“地区”、“日期”、“客户类型”等。它们是您分析数据的“视角”。
*   **示例**：在销售数据中，“产品类别”是一个维度，您可以按产品类别查看销售额。

### 指标 (Metric)

*   **定义**：用于衡量或量化业务绩效的数值。指标通常是定量的，可以进行聚合计算，例如“销售额”、“利润”、“订单量”、“用户数”等。
*   **示例**：在销售数据中，“销售额”是一个指标，您可以计算不同维度的销售额总和、平均值等。

### 洞察 (Insight)

*   **定义**：从数据分析中发现的有价值、可行动的发现或结论。洞察不仅仅是数据本身，更是数据背后揭示的业务含义和趋势。
*   **示例**：发现“周二下午的网站流量最高，但转化率最低”就是一个洞察，可能意味着需要优化周二下午的营销策略。

### 下钻 (Drill-down)

*   **定义**：在数据分析中，从一个高层次的概括性视图深入到更细粒度的详细视图的过程。在 ZY SmartBI 中，下钻通常通过多轮对话的追问来实现，而不是点击图表元素。
*   **示例**：
    1.  先问：“按地区显示销售额”
    2.  再问：“详细看看华东地区的情况”，即可下钻到华东地区的城市或产品销售细节。

### 聚合 (Aggregation)

*   **定义**：将多行数据汇总为一行或几行摘要数据的过程。常见的聚合操作包括求和 (SUM)、平均值 (AVG)、计数 (COUNT)、最大值 (MAX)、最小值 (MIN) 等。
*   **示例**：计算所有产品的“总销售额”或“平均订单价值”。

### 根因分析 (Root Cause Analysis, RCA)

*   **定义**：一种系统性的问题解决方法，旨在识别和解决问题的根本原因，而不是仅仅处理其症状。在 ZY SmartBI 中，指系统通过分析数据，帮助用户找出异常指标背后的主要影响因素。

### What-if 模拟 (What-if Simulation)

*   **定义**：一种预测性分析技术，通过改变一个或多个输入变量，来观察这些变化对输出结果可能产生的影响。用于评估不同情景下的潜在结果。

### 主动洞察 (Proactive Insights)

*   **定义**：系统自动监控关键业务指标，并在检测到异常、重要趋势或达到预设条件时，主动向用户发送通知或提供分析建议的能力。

### 仪表板 (Dashboard)

*   **定义**：一个集成的视图，用于展示多个相关的图表、指标和数据摘要。仪表板帮助用户快速监控关键业务领域的表现。
*   **示例**：创建一个“销售业绩仪表板”，其中包含月度销售趋势图、各地区销售额对比图和关键产品销售额指标卡。

### 仪表板项目 (Dashboard Item)

*   **定义**：仪表板中的单个可视化元素，例如一个图表、一个KPI指标卡或一个表格。

### 仪表板数据源 (Dashboard Source)

*   **定义**：为仪表板项目提供数据的、可复用的命名查询。它通常是一个SQL查询，定义了如何从数据库中提取特定数据。

---

## 技术相关术语

### 自然语言处理 (Natural Language Processing, NLP)

*   **定义**：人工智能的一个分支，旨在使计算机能够理解、解释和生成人类语言。ZY SmartBI 使用 NLP 来理解您的自然语言问题。

### 大型语言模型 (Large Language Model, LLM)

*   **定义**：一种基于深度学习的 AI 模型，通过在海量文本数据上进行训练，能够理解、生成和处理人类语言。ZY SmartBI 使用 LLM 将自然语言问题转换为 SQL 查询。

### 检索增强生成 (Retrieval-Augmented Generation, RAG)

*   **定义**：一种结合了信息检索和文本生成的技术。在 ZY SmartBI 中，RAG 用于从项目元数据和知识库中检索相关信息（如表结构、业务规则、历史查询示例），然后将这些信息作为上下文提供给 LLM，以提高 SQL 生成的准确性和相关性。

### SQL (Structured Query Language)

*   **定义**：一种用于管理关系数据库的标准编程语言。ZY SmartBI 将您的自然语言问题转换为 SQL 语句，以便从数据库中检索数据。

### 元数据 (Metadata)

*   **定义**：关于数据的数据。在 ZY SmartBI 中，元数据包括数据库的表名、列名、数据类型、描述、业务含义等信息，这些信息帮助系统理解数据的结构和内容。

### 向量数据库 (Vector Database)

*   **定义**：一种专门用于存储、管理和检索向量嵌入的数据库。在 ZY SmartBI 中，向量数据库（如 ChromaDB）用于存储元数据和知识库的嵌入，以便进行高效的相似性搜索，支持 RAG 功能。

### PII (Personally Identifiable Information)

*   **定义**：个人身份信息，指任何可以单独或与其他信息结合识别个人身份的数据。在 ZY SmartBI 中，系统会进行 PII 脱敏处理，以保护用户隐私和数据安全。

### RBAC (Role-Based Access Control)

*   **定义**：基于角色的访问控制。一种安全模型，根据用户在组织中的角色来授予或限制其对系统资源的访问权限。

### RLS (Row-Level Security)

*   **定义**：行级安全。一种数据库安全特性，允许根据用户身份或其他条件，限制用户对数据库表中特定行的访问。确保用户只能看到他们被授权查看的数据。
