# ZY SmartBI 常见问题解答 (FAQ)

本部分收集了 ZY SmartBI 用户在使用过程中可能遇到的常见问题及其解答。如果您的问题未在此处列出，请联系您的系统管理员或技术支持。

## 1. 登录与账户

### Q1.1：我忘记了密码怎么办？

**A：** 请联系您的系统管理员重置密码。目前系统不支持用户自助重置密码功能。

### Q1.2：为什么我无法登录，提示“账户被锁定”？

**A：** 这通常是由于多次输入错误密码导致。为了账户安全，系统会自动锁定尝试失败的账户。请等待一段时间后重试，或联系系统管理员解锁您的账户。

### Q1.3: 我是系统管理员，如何在开发或测试时绕过密码验证？

**A：** (仅限管理员) 您可以在系统的 `.env` 配置文件中，将 `LOGIN_DEBUG` 设置为 `True`。启用后，系统将允许使用任意密码随用户名登录，这在开发和测试阶段非常有用。
**请注意：这是一个严重的安全风险，请务必确保在生产环境中将其设置为 `False`。**

## 2. 查询与数据

### Q2.1：为什么我的查询结果是空的？

**A：** 可能有以下几个原因：
*   **数据不存在：** 您查询的条件可能在数据库中没有匹配的数据。
*   **权限不足：** 您可能没有权限访问相关数据。请联系管理员确认您的数据访问权限。
*   **问题不明确：** 您的提问可能过于模糊，导致系统无法准确理解。尝试更具体地描述您的需求。
*   **数据源未连接/更新：** 相关的业务数据源可能尚未连接或数据未及时更新。请联系管理员。

### Q2.2：为什么我的查询速度很慢？

**A：** 查询速度受多种因素影响：
*   **数据量：** 查询的数据量越大，耗时越长。
*   **查询复杂度：** 复杂的聚合、连接或子查询会增加执行时间。
*   **数据源性能：** 后端连接的数据库性能、网络延迟等都会影响查询速度。
*   **系统负载：** 在高峰期，系统可能处理大量并发请求，导致响应变慢。
*   **网络问题：** 您的网络连接不稳定也可能导致感知上的延迟。

### Q2.3：系统无法理解我的问题怎么办？

**A：**
*   **简化问题：** 尝试将复杂的问题拆分为几个简单的问题。
*   **使用业务术语：** 尽量使用您所在行业或公司内部常用的业务术语和指标名称。
*   **提供更多上下文：** 如果是多轮对话，确保您提供了足够的上下文信息。
*   **检查错别字：** 确保您的提问没有明显的拼写错误或语法错误。
*   **联系管理员：** 如果问题持续存在，请向管理员反馈，他们可以帮助您优化提问或检查系统配置。

### Q2.4：我能查询哪些数据？

**A：** 您能查询的数据取决于您的账户权限以及系统已连接并配置的数据源。通常，系统会根据您的角色和部门，为您提供相关业务数据的访问权限。如果您需要访问更多数据，请联系您的管理员。

## 3. 报表与可视化

### Q3.1：为什么我看到的图表和别人不一样？

**A：** 这可能是由于以下原因：
*   **数据权限：** 您的数据访问权限可能与他人不同，导致您看到的数据子集不同。
*   **个性化设置：** 您可能保存了不同的报表或仪表盘视图。
*   **时间范围：** 确保您和他人查询的时间范围是一致的。

### Q3.2：我能自定义图表吗？

**A：** 可以。ZY SmartBI 在生成图表后，提供了丰富的自定义选项：
*   **切换图表类型**：您可以在系统推荐的基础上，从下拉菜单中选择其他图表类型（如柱状图、折线图、饼图、散点图等）。
*   **调整坐标轴**：对于坐标轴图表（如折线图、柱状图），您可以手动选择用于 X 轴和 Y 轴的字段。
*   **更改刻度**：对于折线图，您还可以更改 Y 轴的数值刻度（如线性刻度、对数刻度），以更好地观察数据趋势。
这些选项让您可以根据自己的分析需求，灵活地调整可视化效果。

## 4. 其他

### Q4.1：如何获取最新的功能更新信息？

**A：** 请关注系统公告或查阅 [版本发布说明](docs/admin/07_release_notes.md)（如果管理员已公开）。

### Q4.1：我有一个新功能建议，应该向谁反馈？

**A：** 我们非常欢迎您的建议！请通过内部沟通渠道或联系您的系统管理员提交您的功能建议。
