# ZY SmartBI 用户快速入门指南

欢迎使用 ZY SmartBI！本指南将帮助您在短短几分钟内，完成首次登录、提出第一个问题并获得数据洞察。

## 1. 什么是 ZY SmartBI？

ZY SmartBI 是一款强大的对话式商业智能 (BI) 平台，它允许您使用自然语言与企业数据进行交互。无需复杂的 SQL 知识，您只需提出问题，ZY SmartBI 就能为您生成 SQL 查询、可视化数据并提供智能分析。它支持多轮对话、数据下钻、异常检测和根因分析等高级分析能力，帮助您从数据中获取更深层次的洞察。

## 2. 首次登录与主要界面

1.  打开您的浏览器，访问 ZY SmartBI 的登录页面: `http://127.0.0.1:8000/login`。
2.  如果您是首次使用或使用默认配置，请输入管理员账户：
    *   **用户名:** `admin`
    *   **密码:** `admin1`
3.  点击“登录”按钮。

成功登录后，根据您的用户角色，您将被引导至不同的主界面：
*   **对话式分析 (Chat BI):** 这是所有用户都可以访问的核心界面 (`/chat`)，您可以在这里通过自然语言提问与数据交互。
*   **数据看板 (Dashboard):** 您可以在这里查看和创建数据看板 (`/data_dashboard`)，集中监控关键指标。
*   **管理后台 (Admin):** 管理员用户可以访问 (`/admin/dashboard`)，用于管理数据源、用户、知识库和系统设置等。

建议首次登录后及时修改默认密码。

## 3. 提出您的第一个问题

在聊天输入框中，输入您想查询或分析的数据问题。请尽量使用清晰、具体的自然语言。例如：

*   “显示去年每个月的销售总额。”
*   “2023年，哪个地区的利润最高？”
*   “列出所有活跃客户的姓名和他们的最近一次购买日期。”
*   “为什么上个月的用户增长率下降了？” (分析类问题)
*   “最近的数据有异常吗？” (异常检测)
*   “什么是 GMV？” (知识问答)

输入问题后，按下回车键或点击发送按钮。

![提出问题示例](images/ask_question_example.png)

## 4. 理解查询结果

ZY SmartBI 接收到您的问题后，会执行以下步骤并展示结果：

1.  **SQL 生成与解释**：系统会将您的自然语言问题转换为可执行的 SQL 查询，并提供简要的解释。您通常可以在结果区域看到生成的 SQL 语句（如果启用）。
2.  **数据表格**：SQL 查询执行后，原始数据将以表格形式展示。您可以查看每一行和每一列的具体数值。
3.  **数据可视化**：ZY SmartBI 会根据查询结果的类型，自动生成最合适的图表（如柱状图、折线图、饼图等），帮助您更直观地理解数据。
4.  **分析洞察**：对于分析类问题，ZY SmartBI 会提供结构化的分析结果和洞察。

![结果展示示例](images/results_example.png)

## 5. 获得数据洞察

查看数据表格和可视化图表，结合您最初的问题，您可以快速获得所需的数据洞察。例如，从销售总额的折线图中，您可以一眼看出销售趋势；从地区利润的柱状图中，您可以迅速识别表现最佳的地区。

## 6. 下一步

恭喜您！您已经成功完成了 ZY SmartBI 的首次体验。要了解更多高级功能，例如多轮对话、数据下钻、异常检测、根因分析以及如何利用 ZY SmartBI 进行更深入的分析，请查阅 [核心功能使用手册](02_core_features_guide.md)。
