# ZY SmartBI - Source Code Tree

This document describes the layout of the source code repository.

```
ZY SmartBI/
├── docs/                 # High-level documentation for AI guidance
│   ├── coding-standards.md
│   ├── tech-stack.md
│   └── source-tree.md
├── frontend/             # React frontend application
│   ├── public/
│   └── src/
│       ├── components/   # Reusable React components
│       ├── context/      # React context providers
│       ├── hooks/        # Custom React hooks
│       ├── pages/        # Page-level components
│       ├── services/     # API call services
│       └── styles/       # CSS styles
├── scripts/              # Utility and maintenance scripts
│   └── scan_metadata.py
├── src/                  # Python backend source code
│   ├── api/              # FastAPI endpoints and schemas
│   ├── core/             # Core application logic (config, exceptions)
│   ├── database/         # Database models, session management, CRUD
│   ├── services/         # Business logic services
│   ├── tools/            # Tools for the analysis agent
│   ├── utils/            # Helper utilities (e.g., logging)
│   └── main.py           # FastAPI application entrypoint
├── tests/                # Automated tests
│   ├── unit/             # Unit tests (isolated components)
│   ├── integration/      # Integration tests (component interactions)
│   └── e2e/              # End-to-end tests (full user flows)
├── .env.example          # Environment variable template
├── .gitignore            # Git ignore file
├── pyproject.toml        # Python project configuration (ruff, pytest)
├── README.md             # Project overview and setup guide
└── requirements.txt      # Python dependencies
```
