# ZY SmartBI 最终文档体系规划

本文档定义了 ZY SmartBI 项目的完整文档集合，旨在为不同角色的用户提供清晰、准确、全面的指引。文档体系按目标读者分为三大类：**用户文档**、**管理员文档** 和 **技术文档**。

---

## 1. 面向最终用户 (User-Facing Documentation)

**目标**：帮助业务用户快速上手，充分利用系统的分析能力解决实际问题。
**建议目录**：`docs/user/`

| 文档名称                 | 建议文件名                      | 核心内容                                                                                             |
| ------------------------ | ------------------------------- | ---------------------------------------------------------------------------------------------------- |
| **用户快速入门指南**     | `01_quick_start.md`             | 5分钟教程，引导用户完成首次登录、提出第一个问题、与图表互动并获得洞察。                                |
| **核心功能使用手册**     | `02_core_features_guide.md`     | 详细介绍所有核心功能：如何有效提问、多轮追问、解读不同类型的图表、分享或导出结果。                   |
| **高级功能使用手册**     | `03_advanced_features_guide.md` | 专门介绍高级分析功能，如如何提问以触发根因分析、进行 What-if 模拟、以及使用系统的主动洞察功能。      |
| **常见问题解答 (FAQ)**   | `04_faq.md`                     | 解答用户最常遇到的问题，例如：“为什么我的查询很慢？”、“为什么系统无法理解我的问题？”等。         |
| **业务术语表 (Glossary)**| `05_glossary.md`                | 解释产品中可能出现的业务和技术术语，如“维度”、“指标”、“下钻”、“RAG”等，消除理解障碍。             |

---

## 2. 面向系统管理员 (Administrator Documentation)

**目标**：确保系统管理员能够独立完成应用的部署、配置、集成和日常维护。
**建议目录**：`docs/admin/`

| 文档名称                 | 建议文件名                          | 核心内容                                                                                             |
| ------------------------ | ----------------------------------- | ---------------------------------------------------------------------------------------------------- |
| **管理员快速入门指南**   | `01_quick_start.md`                 | 10分钟教程，指导管理员完成首次部署、连接第一个数据源、创建第一个用户角色。                           |
| **安装与部署指南**       | `02_installation_guide.md`          | 在服务器上从零开始安装和部署 ZY SmartBI 的完整步骤，包括环境依赖、数据库初始化和服务启动。        |
| **系统配置手册**         | `03_system_configuration.md`        | 逐一解释 `.env` 文件和管理后台中所有可配置项的含义和作用，如 LLM Keys、数据库连接、缓存设置等。     |
| **数据源管理手册**       | `04_datasource_management.md`       | 指导如何连接、扫描和管理不同的数据仓库，以及如何验证元数据和连接状态。                               |
| **安全与用户管理手册**   | `05_security_user_management.md`    | (关键) 详细说明如何管理用户、创建角色、分配权限 (RBAC)，以及配置行列级安全 (RLS) 策略。             |
| **知识库管理手册**       | `06_knowledge_base_management.md`   | 指导如何添加和管理知识库的源文件目录、如何触发索引、以及如何验证知识库的有效性。                     |
| **版本发布说明**         | `07_release_notes.md`               | 每个版本发布时更新，说明新增功能、修复的 Bug、以及可能的重大变更。                                   |

---

## 3. 面向技术团队 (Technical Documentation)

**目标**：为开发、运维、安全和集成团队提供深入的技术参考。
**建议目录**：`docs/technical/`

| 文档大类         | 文档名称                 | 建议文件名 (`technical/`下)      | 核心内容                                                                                             |
| ---------------- | ------------------------ | -------------------------------- | ---------------------------------------------------------------------------------------------------- |
| **开发文档**     | **开发环境与流程**       | `developer/01_dev_setup.md`      | 指导开发者配置本地开发环境、代码贡献流程 (Git Flow)、Commit 规范、测试策略等。                       |
|                  | **代码库结构导览**       | `developer/02_codebase_tour.md`  | 介绍 `src` 目录下各模块的职责和关系，帮助新开发者快速理解代码结构。                                  |
|                  | **核心模块深入解析**     | `developer/03_deep_dives/`       | (子目录) 深入剖析核心模块设计，如编排引擎、RAG 服务、Text2SQL 等。                                   |
|                  | **系统扩展指南**         | `developer/04_how_to_extend.md`  | 提供教程，指导如何添加新的数据源连接器、分析工具或 LLM 接口。                                        |
| **运维文档**     | **监控、告警与日志**     | `operations/01_monitoring.md`    | 如何配置和接入监控系统 (Prometheus/Grafana)，关键性能指标 (KPIs)，以及如何查询和分析结构化日志。     |
|                  | **备份与灾难恢复**       | `operations/02_backup_recovery.md` | 详细的数据库和向量存储的备份与恢复策略和操作步骤。                                                   |
|                  | **常见故障排查**         | `operations/03_troubleshooting.md` | 提供一个检查清单和解决方案集，用于快速诊断和解决服务启动失败、性能下降、API 错误等常见问题。       |
| **API 参考**     | **API 接口文档**         | `api/index.md`                   | (可内嵌 Swagger UI) 提供所有公开 API 的详尽技术说明，包括端点、方法、参数、请求体、响应示例和错误码。 |
| **安全文档**     | **安全与合规手册**       | `security/index.md`              | 详细阐述系统安全架构、数据加密、PII 处理、依赖项安全扫描、以及为满足合规性审计提供的支持。         |