# ZY SmartBI 知识库管理手册

本手册旨在指导 ZY SmartBI 系统管理员如何有效地管理知识库。知识库是 ZY SmartBI RAG (Retrieval-Augmented Generation) 服务的重要组成部分，它为 LLM 提供额外的上下文信息，以提高查询的准确性和相关性。

## 1. 什么是知识库？

知识库是 ZY SmartBI 用于增强其理解和生成能力的数据集合。它通常包含：

*   **业务规则**：例如，特定指标的计算逻辑、业务流程说明。
*   **数据字典**：对表和列的更详细、更具业务含义的描述。
*   **历史查询示例**：用户提问和对应 SQL 的成功案例，作为 LLM 的 Few-shot 学习样本。
*   **其他文档**：如产品手册、FAQ、公司内部报告等，可以作为 LLM 回答知识性问题的补充。

知识库中的内容会被处理成向量嵌入，存储在向量数据库中，供 RAG 服务检索。

## 2. 知识库源文件管理

知识库的内容通常以文件形式存在于文件系统中。管理员需要指定这些文件的存储位置。

### 2.1 配置知识库源文件目录

1.  **准备源文件**：将您的业务规则、数据字典、历史查询示例等文档整理成支持的格式（如 Markdown, TXT, PDF 等）并存放在服务器的某个目录下。
    *   **建议**：为不同类型的知识库内容创建独立的子目录，例如：
        ```
        /knowledge_base
        ├── /business_rules
        ├── /data_dictionary
        └── /query_examples
        ```
2.  **添加知识源目录到 ZY SmartBI**：
    *   您可以通过管理员 Web 界面或直接调用 API 来添加知识源目录。
    *   **API 示例**：`POST /api/v1/knowledge/directories`
        *   **请求体**：`{"name": "Business Rules", "path": "/path/to/your/knowledge_base/business_rules", "description": "公司业务规则文档"}`
    *   **注意**：请确保 ZY SmartBI 服务运行的用户对这些目录具有读取权限。

## 3. 知识库索引

将知识库源文件转换为向量嵌入并存储到向量数据库的过程称为“索引”。只有经过索引的知识库内容才能被 RAG 服务检索。

### 3.1 手动触发索引

当您添加、修改或删除了知识库源文件后，需要手动触发索引更新，以确保 ZY SmartBI 使用的是最新版本的知识。

1.  **通过 Web 界面触发**：
    *   登录管理员界面，导航到“知识库管理”或“系统设置”页面。
    *   找到“知识库索引”或“刷新知识库”按钮，点击它。
    *   系统将开始扫描配置的知识库目录，处理新增/修改的文件，并更新向量数据库。
2.  **通过 API 触发**：
    *   **全量索引**：`POST /api/v1/knowledge/index`

### 3.2 自动索引 (可选)

在某些部署中，可以配置 ZY SmartBI 定期自动扫描和索引知识库目录，以保持知识库的最新状态。这通常通过后台调度任务实现。请查阅 [系统配置手册](03_system_configuration.md) 或运维手册了解相关配置。

## 4. 验证知识库有效性

索引完成后，您可以通过以下方式验证知识库是否正常工作：

1.  **测试查询**：
    *   尝试向 ZY SmartBI 提出一个需要知识库内容才能准确回答的问题。例如，如果您的知识库中包含了某个特定业务指标的计算公式，您可以提问：“‘客户生命周期价值’是如何计算的？”
    *   观察 ZY SmartBI 的回答是否准确、完整，并是否引用了知识库中的信息。
    *   **API 示例**：`GET /api/v1/knowledge/search?q=<query_string>`
2.  **查看日志**：
    *   检查 ZY SmartBI 的运行日志，特别是 RAG 服务的日志。日志中可能会显示知识库检索的详细信息，例如检索到了哪些文档片段、相似度分数等。

## 5. 知识库维护

### 5.1 清空知识库

如果您希望完全重建知识库，可以执行清空操作。
*   **通过 Web 界面**: 在“知识库管理”页面，通常会有一个“清空知识库”的按钮。
*   **通过 API**: `POST /api/v1/knowledge/clear`
*   **注意**: 此操作会删除向量数据库中所有用户上传的知识文档，但不会删除您在文件系统中配置的源文件。

### 5.2 删除单个文档

系统会根据文件内容生成唯一的文档 ID。如果需要，您可以根据此 ID 删除单个已索引的文档。
*   **通过 API**: `DELETE /api/v1/knowledge/documents/{doc_id}`
*   **使用场景**: 当您只想移除某个特定的、不再需要的文件，而不想重新索引整个目录时，此功能非常有用。

## 6. 知识库内容优化建议

*   **清晰简洁**：知识库中的文档内容应清晰、简洁、无歧义。
*   **结构化**：尽量使用 Markdown 等格式，使文档结构化，便于系统解析和理解。
*   **定期更新**：业务规则和数据定义可能会随时间变化，请定期更新知识库内容并重新索引。
*   **避免冗余**：避免知识库中存在大量重复或过时信息，这会影响检索效率和准确性。

## 7. 后续步骤

知识库的有效管理是提升 ZY SmartBI 智能水平的关键。了解更多关于系统日志和故障排查的信息，请查阅运维相关的技术文档。

