# ZY SmartBI 安全与用户管理手册

本手册旨在指导 ZY SmartBI 系统管理员如何有效地管理用户账户、角色和权限，并配置数据安全策略，包括行级安全 (RLS) 和列级安全 (CLS)。确保数据安全和合规性是 ZY SmartBI 运行的核心。

## 1. 用户管理

用户管理是控制谁可以访问 ZY SmartBI 系统的基础。

### 1.1 创建新用户

1.  **登录管理员界面**：使用您的管理员账户登录 ZY SmartBI Web 界面。
2.  **导航到用户管理**：在管理界面中找到“用户管理”或“用户列表”入口。
3.  **点击“添加新用户”**：填写以下信息：
    *   **用户名**：用户的唯一标识符。
    *   **密码**：为用户设置初始密码。建议强制用户首次登录后修改密码。
    *   **邮箱** (可选)：用于通知或密码找回。
    *   **状态**：启用/禁用用户账户。
4.  **保存用户**：点击保存按钮完成用户创建。
    *   **API 示例**：`POST /api/v1/auth/users`

### 1.2 编辑和删除用户

*   **编辑用户**：在用户列表中选择要编辑的用户，修改其信息（如密码、邮箱、状态），然后保存。
    *   **API 示例**：`PUT /api/v1/rbac/users/{user_id}`
*   **删除用户**：在用户列表中选择要删除的用户。**注意**：删除用户是不可逆操作，请谨慎执行。
    *   **API 示例**：`DELETE /api/v1/rbac/users/{user_id}`

## 2. 角色管理 (RBAC - Role-Based Access Control)

角色是权限的集合。通过将权限分配给角色，再将角色分配给用户，可以简化权限管理。

### 2.1 创建新角色

1.  **导航到角色管理**：在管理界面中找到“角色管理”或“角色与权限”入口。
2.  **点击“创建新角色”**：
    *   **角色名称**：为角色指定一个描述性名称（例如：`Sales_Analyst`, `Marketing_Manager`, `HR_Viewer`）。
    *   **角色描述** (可选)：简要说明该角色的职责和权限范围。
3.  **分配权限**：
    *   **数据源访问权限**：选择该角色可以访问哪些已配置的数据源。
    *   **功能权限**：例如，是否允许该角色创建报表、分享洞察、访问管理后台特定模块等。
4.  **保存角色**：点击保存按钮。
    *   **API 示例**：`POST /api/v1/rbac/roles`

### 2.2 编辑和删除角色

*   **编辑角色**：修改角色的名称、描述或权限。
    *   **API 示例**：`PUT /api/v1/rbac/roles/{role_id}`
*   **删除角色**：删除不再需要的角色。**注意**：在删除角色之前，请确保没有用户被分配到该角色，或将这些用户重新分配到其他角色。
    *   **API 示例**：`DELETE /api/v1/rbac/roles/{role_id}`

### 2.3 为用户分配角色

1.  **导航到用户管理**：找到要分配角色的用户。
2.  **编辑用户**：在用户编辑界面，找到“角色”或“分配角色”部分。
3.  **选择角色**：从可用角色列表中选择一个或多个角色分配给该用户。
4.  **保存**：保存用户更改。
    *   **API 示例**：`POST /api/v1/rbac/user-roles` (分配), `DELETE /api/v1/rbac/user-roles` (移除)

## 3. 数据权限控制 (RLS & CLS)

ZY SmartBI 支持通过行级安全 (RLS) 和列级安全 (CLS) 实现精细化的数据访问控制。

*   **行级安全 (Row-Level Security, RLS)**: 允许您根据用户身份限制其对数据库表中特定行的访问。例如，销售经理只能看到自己团队的销售数据。
*   **列级安全 (Column-Level Security, CLS)**: 允许您限制用户对数据库表中特定列的访问。例如，只有 HR 部门的用户才能看到员工的薪资信息。

在当前版本中，RLS 和 CLS 策略的定义与应用是高级功能，通常在角色创建时通过后端 API 进行配置。管理员可以在角色权限配置中，为特定数据表定义行过滤条件或指定可访问的列列表。当拥有该角色的用户查询数据时，系统会自动应用这些安全策略。

## 5. PII 数据脱敏

ZY SmartBI 内置了 PII (个人身份信息) 脱敏功能，以保护敏感数据在传输和处理过程中不被泄露，尤其是在与外部 LLM 服务交互时。

*   **启用/禁用**：PII 脱敏功能通常通过系统配置（`.env` 文件中的 `PII_SCRUBBING_ENABLED`）进行全局控制。
*   **配置规则**：管理员可以在系统后台配置 PII 识别规则（例如，通过正则表达式定义邮箱、电话号码、身份证号等模式），这些规则可以从数据库动态加载。
    *   **API 示例**：`POST /api/v1/settings/pii` (用于更新 PII 模式，如果已实现)

## 6. 审计日志

ZY SmartBI 会记录用户的关键操作和系统事件，形成审计日志。这对于安全审计、问题追踪和合规性要求至关重要。

*   **查看审计日志**：管理员可以在管理界面中访问“审计日志”模块，查看用户登录、数据查询、配置更改等详细记录。
    *   **API 示例**：`GET /api/v1/audit-logs`
*   **日志配置**：日志级别和存储路径可以在 [系统配置手册](03_system_configuration.md) 中进行配置。

## 7. 后续步骤

*   **知识库管理**：了解如何管理 ZY SmartBI 的知识库，请查阅 [知识库管理手册](06_knowledge_base_management.md)。
*   **日常运维**：了解系统监控和故障排查，请查阅 [监控、告警与日志](docs/technical/operations/01_monitoring.md) 和 [常见故障排查](docs/technical/operations/03_troubleshooting.md)。
