# ZY SmartBI 数据源管理手册

本手册旨在指导 ZY SmartBI 系统管理员如何连接、配置、扫描和管理各种业务数据源。正确的数据源管理是 ZY SmartBI 正常运行和提供准确数据分析的基础。

## 1. 支持的数据源类型

ZY SmartBI 支持连接多种主流数据库作为数据源，包括：

*   POSTGRESQL
*   MYSQL
*   SQLITE
*   SQLSERVER
*   OCEANBASE
*   TIDB
*   SNOWFLAKE
*   BIGQUERY
*   REDSHIFT
*   CLICKHOUSE
*   ORACLE
*   DB2
*   TRINO
*   DATABRICKS
*   ATHENA

## 2. 添加新数据源

添加数据源是 ZY SmartBI 获取业务数据的第一步。您可以通过管理员 Web 界面来完成。

1.  **登录管理员界面**：使用您的管理员账户登录 ZY SmartBI Web 界面。
2.  **导航到数据源管理**：在左侧导航栏或顶部菜单中找到并点击“数据源管理”或类似入口。
3.  **点击“添加新数据源”**：通常是一个按钮，如 `+ 添加数据源`。
4.  **填写数据源信息**：
    *   **数据源名称 (Name)**：为您的数据源指定一个唯一且易于识别的名称（例如：`Sales_DW`, `Marketing_DB`）。
    *   **数据库类型 (Type)**：从下拉列表中选择您要连接的数据库类型。
    *   **连接参数 (Connection Parameters)**：根据所选的数据库类型，填写相应的连接信息。
5.  **测试连接**：点击“测试连接”按钮，系统将尝试使用您提供的凭据连接到数据库，并返回连接结果。确保连接成功。
6.  **保存数据源**：连接测试成功后，点击“保存”按钮，将数据源信息存储到 ZY SmartBI 的元数据数据库中。

## 3. 导入元数据

数据源添加成功后，ZY SmartBI 需要扫描该数据源的元数据（表、列、数据类型、描述等），以便 Text2SQL 引擎能够理解其结构并生成正确的 SQL 查询。

在“数据源管理”页面，找到您想要扫描的数据源，点击“导入元数据”或“刷新”按钮。系统将开始扫描，此过程可能需要一些时间。

## 4. 管理现有数据源

在“数据源管理”页面，您可以对已添加的数据源进行以下操作：

*   **编辑**：修改数据源的连接参数或名称。
*   **删除**：从 ZY SmartBI 中移除数据源。**注意**：删除数据源不会影响您的实际数据库，但会删除 ZY SmartBI 中所有相关的元数据。
*   **刷新元数据**：当您的业务数据库结构发生变化（例如，添加了新表、修改了列名）时，您需要重新“导入元数据”。

## 5. 高级元数据管理

除了基本的元数据扫描，ZY SmartBI 还提供了强大的 AI 辅助元数据管理功能，以进一步提升 Text2SQL 的准确性。这些操作通常在数据源的元数据管理页面中提供。

*   **AI 生成描述与逻辑 (`Generate Metadata`)**：这是最核心的 AI 增强功能。系统会利用 LLM 分析表的结构、列名和抽样数据，自动为表和列填充业务描述、同义词，并为表生成“选择逻辑” (Selection Logic)。“选择逻辑”会指导 AI 在面对用户的模糊问题时，如何更智能地选择合适的表。
*   **清除 AI 生成的描述 (`Clear Descriptions`)**：如果您希望移除所有 AI 生成的描述和同义词，并重新手动填写，可以使用此功能。
*   **清除选择逻辑 (`Clear Selection Logic`)**：此功能会单独清除 AI 为表生成的“选择逻辑”，而不影响其他描述信息。
*   **删除所有元数据 (`Delete All Metadata`)**：此操作会彻底删除 ZY SmartBI 中关于此数据源的所有元数据记录（包括表、列、描述等）。删除后，您需要重新“导入元数据”才能再次使用该数据源。这在数据源结构发生重大变化时非常有用。

## 6. 数据源安全

*   **最小权限原则**：为 ZY SmartBI 连接数据库的用户配置最小必要的权限。只授予查询所需表的读取权限，避免授予不必要的写入、修改或删除权限。
*   **凭证安全**：确保数据库连接凭证（尤其是密码）存储在安全的环境变量或加密配置中，避免硬编码。
*   **网络隔离**：如果可能，将 ZY SmartBI 部署在与数据源相同的安全网络环境中，并限制外部访问。

## 7. 后续步骤

数据源配置完成后，您需要为用户分配访问这些数据源的权限。请查阅 [安全与用户管理手册](05_security_user_management.md) 以了解如何进行用户和权限管理。

