# ZY SmartBI 系统配置手册

本手册详细介绍了 ZY SmartBI 系统的各项配置项，包括环境变量、数据库连接、LLM 服务设置、以及其他系统级参数。理解并正确配置这些参数对于系统的稳定运行和性能优化至关重要。

## 1. 配置优先级说明

ZY SmartBI 采用分层配置系统，以实现灵活性和安全性：

1.  **数据库配置 (最高优先级)**：通过系统管理界面的“系统设置”页面保存的配置。这些设置存储在数据库中，并**在运行时动态加载**，可以**即时生效**，无需重启服务。

2.  **环境变量 (`.env` 文件)**：项目根目录下的 `.env` 文件。这些配置在**应用启动时**被加载，作为系统的**默认值**或**备用值**。

**核心原则**：如果在数据库中存在某个设置项，它将**覆盖** `.env` 文件中的同名设置。这意味着，**通过管理界面所做的更改总是优先的**。

## 2. 通过管理界面进行系统设置 (推荐)

我们强烈建议管理员通过系统内置的管理界面来配置系统。这不仅更安全，而且更改可以即时生效。

- **访问路径**：登录系统后，导航至 `管理` -> `系统设置`。
- **可配置项**：
    - **AI 提供商设置**：管理各大模型服务提供商（如 OpenAI, Gemini 等）的 API 密钥和 API Base URL。
        - **API 密钥**：为了安全，系统不会显示已保存的密钥。只会提示“已设置”或“未设置”。您可以随时输入新的密钥来更新它。
        - **API Base URL**：如果您的网络环境需要通过代理访问 LLM 服务，可以在此配置代理地址。
    - **系统提示模板**：自定义系统在不同场景下与 LLM 交互时使用的提示模板。
        - **知识问答提示模板**：当用户的提问被识别为“知识问答”意图时使用。此模板旨在引导 LLM 利用其知识库和已知的业务上下文来回答关于数据定义、业务术语等问题。
        - **回退提示模板**：当系统无法理解用户意图或无法执行请求时使用。此模板旨在为用户提供清晰的指引，告诉他们系统能做什么，并给出有效的提问示例。
        - **澄清问题提示模板**：当用户的问题不够清晰，需要更多信息才能执行时使用。此模板引导 LLM 生成一个具体的问题，以帮助用户提供必要的上下文（如时间范围、维度等）。
        - **系统通用提示模板**：作为通用的系统级指令，为 LLM 提供其在对话中的基本角色定位和行为准则。

## 3. 通过 .env 文件进行配置 (备用)

`.env` 文件主要用于配置系统的初始默认值或在无法访问数据库时提供备用配置。修改此文件后，**必须重启 ZY SmartBI 服务**才能生效。

### 3.1 数据库配置

*   **`DB_SERVER_TYPE`**
    *   **说明**: 指定 ZY SmartBI 内部元数据数据库的类型。系统会根据此类型和下方其他 `DB_*` 变量来构建最终的 `DATABASE_URL`。如果 `DATABASE_URL` 已被直接设置，则此项无效。
    *   **可选值**: `SQLite`, `PostgreSQL`
    *   **示例**: `DB_SERVER_TYPE=PostgreSQL`

*   **`DATABASE_URL`**
    *   **说明**：直接指定 ZY SmartBI 内部元数据数据库的连接字符串。如果设置了此项，则会忽略 `DB_SERVER_TYPE` 和其他 `DB_*` 变量。
    *   **格式**:
        *   **SQLite (默认)**：`sqlite+aiosqlite:///./insightlink_dev.db`
        *   **PostgreSQL**：`postgresql+asyncpg://user:password@host:port/database_name`

*   **`DB_USER`, `DB_PASSWORD`, `DB_HOST`, `DB_PORT`, `DB_NAME`**
    *   **说明**: 当 `DB_SERVER_TYPE` 设置为 `PostgreSQL` 时，用于构建连接字符串的各个部分。

*   **`VECTOR_STORE_PATH`**
    *   **说明**：ChromaDB 向量数据库的存储路径。该数据库用于存储 RAG 服务所需的嵌入向量。
    *   **格式**：文件系统路径，例如：`./chroma_db` (表示在项目根目录下创建 `chroma_db` 文件夹)
    *   **重要提示**：确保该路径可写，并且有足够的磁盘空间。

### 3.2 LLM 服务配置

*   **`OPENAI_API_KEY`**, **`ANTHROPIC_API_KEY`**, **`GEMINI_API_KEY`**, **`DEEPSEEK_API_KEY`**, **`DASHSCOPE_API_KEY`**
    *   **说明**：对应 LLM 服务的 API Key。根据您选择的 LLM 提供商，填写对应的 API Key。

*   **`LLM_LOAD_BALANCING_ENABLED`**
    *   **说明**：是否启用 LLM 负载均衡。启用后，系统会根据配置的权重在多个 LLM 提供商之间分配请求。
    *   **可选值**：`True`, `False`
    *   **示例**：`LLM_LOAD_BALANCING_ENABLED=True`

*   **`LLM_PARALLEL_CALLING_ENABLED`**
    *   **说明**：是否启用 LLM 并行调用。启用后，系统会同时向多个 LLM 提供商发送请求，并根据 `LLM_SELECTION_STRATEGY` 选择最快或最优的响应。
    *   **可选值**：`True`, `False`
    *   **示例**：`LLM_PARALLEL_CALLING_ENABLED=True`

*   **`LLM_SELECTION_STRATEGY`**
    *   **说明**：当启用并行调用时，选择 LLM 响应的策略。
    *   **可选值**：`FIRST_COMPLETED` (最快完成), `CHEAPEST` (最便宜), `HIGHEST_QUALITY` (最高质量)。
    *   **示例**：`LLM_SELECTION_STRATEGY=FIRST_COMPLETED`

*   **`LLM_PROVIDERS`**
    *   **说明**：配置每个 LLM 提供商的权重、成本和质量，用于负载均衡和选择策略。这是一个 JSON 字符串。
    *   **格式**：`[{"name": "openai", "weight": 1, "cost": 0.001, "quality": 0.8}, {"name": "gemini", "weight": 0, "cost": 0.002, "quality": 0.9}]`

*   **`OPENAI_TEXT_MODEL`**, **`ANTHROPIC_TEXT_MODEL`**, **`GEMINI_TEXT_MODEL`**, **`DEEPSEEK_TEXT_MODEL`**
    *   **说明**：指定用于文本生成任务的具体 LLM 模型名称。

*   **`OPENAI_EMBEDDING_MODEL`**, **`GEMINI_EMBEDDING_MODEL`**, **`DASHSCOPE_EMBEDDING_MODEL`**
    *   **说明**：指定用于嵌入生成任务的具体 LLM 模型名称。

*   **`LLM_TEMPERATURE`**
    *   **说明**：LLM 的温度参数，控制生成文本的随机性。值越高，输出越随机；值越低，输出越确定。
    *   **范围**：0.0 到 1.0
    *   **示例**：`LLM_TEMPERATURE=0.7`

*   **`GEMINI_THINK_BUDGET`**
    *   **说明**：Gemini 模型思考过程的预算（秒），用于控制其生成响应前的思考时间。
    *   **示例**：`GEMINI_THINK_BUDGET=300`

### 3.3 安全与隐私配置

*   **`SECRET_KEY`**
    *   **说明**：用于加密和安全签名的密钥。**在生产环境中，务必将其设置为一个长、随机且复杂的字符串。**
    *   **示例**：`SECRET_KEY=your_super_secret_and_random_key_here`

*   **`LOGIN_DEBUG`**
    *   **说明**：是否启用调试登录模式。启用后，系统将允许使用任意密码随用户名登录。
    *   **可选值**：`True`, `False`
    *   **警告**：这是一个严重的安全风险，请务必确保在生产环境中将其设置为 `False`。

*   **`PII_SCRUBBING_ENABLED`**
    *   **说明**：是否启用 PII (个人身份信息) 脱敏功能。启用后，在发送数据到外部 LLM 服务前，系统会自动识别并替换敏感信息。PII 模式可以从数据库动态加载。
    *   **可选值**：`True`, `False`
    *   **示例**：`PII_SCRUBBING_ENABLED=True`

### 3.4 日志与监控配置

*   **`LOG_LEVEL`**
    *   **说明**：系统日志的输出级别。控制哪些级别的日志信息会被记录。ZY SmartBI 使用 `structlog` 进行结构化日志记录。
    *   **可选值**：`DEBUG`, `INFO`, `WARNING`, `ERROR`, `CRITICAL`
    *   **示例**：`LOG_LEVEL=INFO`

*   **`LOG_FILE_PATH`**
    *   **说明**：系统日志文件的存储路径。如果未设置，日志可能输出到控制台。
    *   **示例**：`LOG_FILE_PATH=./logs/ZY SmartBI.log`

### 3.5 其他配置

*   **`MAX_CONCURRENT_QUERIES`**
    *   **说明**：系统允许同时处理的最大并发查询数量。根据服务器资源和预期负载进行调整。
    *   **示例**：`MAX_CONCURRENT_QUERIES=10`

*   **`METADATA_SCAN_INTERVAL_HOURS`**
    *   **说明**：自动扫描数据源元数据的间隔时间（小时）。设置为 0 表示禁用自动扫描。
    *   **示例**：`METADATA_SCAN_INTERVAL_HOURS=24`

*   **`MAX_CONVERSATION_HISTORY_MESSAGES`**
    *   **说明**：在对话中保留的最大历史消息数量，用于提供上下文。
    *   **示例**：`MAX_CONVERSATION_HISTORY_MESSAGES=20`

*   **`MAX_SAMPLE_ROWS_IN_HISTORY`**
    *   **说明**：在对话历史中存储数据结果时，保留的最大样本行数，以避免存储过多敏感数据。
    *   **示例**：`MAX_SAMPLE_ROWS_IN_HISTORY=5`

## 4. 后续步骤

*   **数据源管理**：了解如何连接和管理您的业务数据源，请查阅 [数据源管理手册](04_datasource_management.md)。
*   **安全与用户管理**：了解如何配置用户权限和安全策略，请查阅 [安全与用户管理手册](05_security_user_management.md)。
