# ZY SmartBI 安装与部署指南

本指南详细介绍了如何在服务器环境中从零开始安装和部署 ZY SmartBI。请按照以下步骤操作，确保您的部署顺利进行。

## 1. 环境与软件包准备

### 1.1 系统与硬件要求

*   **操作系统**: Windows 10 或更高版本。
*   **硬件**: 建议 4核 CPU, 8GB RAM, 50GB 可用磁盘空间。
*   **网络**: 稳定的互联网连接，用于访问 LLM 服务。

### 1.2 核心软件包

您需要准备以下核心软件的安装包：
*   **PostgreSQL**: 建议最新版本 (如 17.6)。
*   **Python**: 建议 3.13.6 版本。

您可以从官方网站下载，或使用我们提供的网盘链接。请将下载的软件包放置在发布包的根目录下。

## 2. 安装步骤

我们提供了一系列批处理脚本 (`.bat`) 来简化安装过程。

### 步骤 1: 安装核心组件

*   双击运行 `安装 展映 AI 智慧经营.bat` 脚本，安装核心组件。
*   双击运行 `安装python.bat` 脚本，安装 ZY SmartBI 所需的 Python 环境和依赖库。
*   **重要**: 安装 PostgreSQL 后，请运行 `services.msc` 打开服务管理器，找到 `postgresql` 服务，并将其启动类型设置为“自动”。

### 步骤 2: 配置环境变量 (`.env` 文件)

1.  在项目根目录下，找到 `.env.example` 文件，复制并重命名为 `.env`。
2.  使用文本编辑器打开 `.env` 文件，并配置以下关键信息：
    *   **数据库连接**:
        ```env
        DB_USER=postgres
        DB_PASSWORD=ZYCBI2025 # 请修改为您的PostgreSQL密码
        DB_HOST=127.0.0.1
        DB_PORT=5432
        DB_NAME=chatbi_forge_dev
        ```
    *   **管理员账户 (首次启动时创建)**:
        ```env
        DEFAULT_ADMIN_USERNAME=admin
        DEFAULT_ADMIN_PASSWORD=admin1
        ```
    *   **调试登录 (可选)**:
        ```env
        # 设置为 True 可使用任意密码登录，仅限开发测试环境
        LOGIN_DEBUG=True 
        ```
    *   **LLM API 密钥 (至少配置一个)**:
        ```env
        DEEPSEEK_API_KEY=your_deepseek_api_key_here
        DASHSCOPE_API_KEY=your_dashscope_api_key_here
        DASHSCOPE_API_BASE_URL=https://dashscope.aliyuncs.com/api/v1
        ```
    *   **项目信息文件路径 (可选)**:
        ```env
        PROJECT_INFO_FILE_PATH=ZYchatBI_project_info.txt
        ```

### 步骤 3: 初始化数据

*   双击运行 `初始化数据.bat` 脚本。
*   此脚本将连接到您在 `.env` 文件中配置的数据库，并创建所需的表结构和导入示例数据。

### 步骤 4: 启动服务

*   双击运行 `运行 ZY chatBI.bat` 脚本。
*   服务启动大约需要 40 秒。启动成功后，您可以通过浏览器访问系统。

## 3. 访问系统

*   **用户登录**: `http://127.0.0.1:8000/login`
*   **对话界面**: `http://127.0.0.1:8000/chat`
*   **管理员界面**: `http://127.0.0.1:8000/admin/dashboard`

## 4. 后续步骤

部署完成后，请参考以下手册进行后续配置：
*   **数据源管理**: [数据源管理手册](04_datasource_management.md)
*   **用户与权限**: [安全与用户管理手册](05_security_user_management.md)
*   **系统配置**: [系统配置手册](03_system_configuration.md)