# ZY SmartBI 管理员快速入门指南

欢迎使用 ZY SmartBI 管理员指南！本指南旨在帮助您在系统首次运行后，快速完成核心管理任务，让业务用户可以开始使用。

本指南假设您已根据 [安装与部署指南](02_installation_guide.md) 完成了 ZY SmartBI 的全部安装和启动步骤。

## 1. 首次登录管理员账户

1.  **访问系统**：在浏览器中访问 `http://127.0.0.1:8000/login`。
2.  **使用默认凭据登录**：
    *   用户名: `admin`
    *   密码: `admin1`
3.  登录后，建议您立即导航到用户管理模块，修改默认管理员的密码。

## 2. 连接第一个业务数据源

ZY SmartBI 的核心是连接到您的企业数据。以下是连接一个数据源的快速步骤：

1.  **导航到数据源管理**：登录后，在左侧菜单或顶部导航栏找到“数据源管理”。
2.  **添加数据源**：
    *   点击“添加新数据源”。
    *   填写数据源的唯一名称（如 `sales_dw`）、选择数据库类型（如 `POSTGRESQL`），并填入连接参数。
    *   点击“测试连接”以验证配置是否正确。
    *   保存数据源。

## 3. 导入并丰富元数据

数据源连接后，需要让 ZY SmartBI 理解其中的数据结构。请导航至“元数据管理”页面。

1.  **选择数据源**：在页面顶部，从下拉菜单中选择您刚刚添加的数据源。
2.  **导入元数据**：点击“导入数据源元数据”按钮。此操作会读取数据库中的表和列信息，并将其录入 ZY SmartBI 系统。
3.  **AI 生成描述 (推荐)**：导入成功后，点击“AI 自动生成元数据”按钮。系统会利用 AI 分析表结构和抽样数据，自动为表和列生成业务描述、同义词等，这将极大提升后续自然语言转 SQL 的准确率。

## 4. 创建第一个用户与角色

1.  **创建角色**：
    *   导航到“角色与权限管理”。
    *   创建一个新角色，例如 `Sales_Analyst`。
    *   为该角色分配刚刚创建的数据源（`sales_dw`）的访问权限。
2.  **创建用户**：
    *   导航到“用户管理”。
    *   创建一个新用户，并将其分配到 `Sales_Analyst` 角色。

## 5. 下一步

恭喜您！您已成功完成了 ZY SmartBI 的核心配置。现在，您创建的业务用户已经可以使用他们的账户登录，并开始针对 `sales_dw` 数据源进行提问和分析了。

要深入了解更多高级管理功能，请查阅：
*   [系统配置手册](03_system_configuration.md)
*   [数据源管理手册](04_datasource_management.md)
*   [安全与用户管理手册](05_security_user_management.md)

