# ZhanYing ZY SmartBI Comprehensive User Manual

Welcome to ZhanYing ZY SmartBI! This manual is your one-stop guide to help users and administrators fully understand, efficiently use, and easily maintain the ZhanYing ZY SmartBI platform.

---

## Table of Contents

*   [**Chapter 1: Product Introduction**](#chapter-1)
    *   [1.1 What is ZY SmartBI?](#1.1)
    *   [1.2 Product Vision](#1.2)
    *   [1.3 Who is it designed for?](#1.3)
*   [**Chapter 2: User Guide**](#chapter-2)
    *   [2.1 Quick Start](#2.1)
    *   [2.2 Core Function Details](#2.2)
    *   [2.3 Advanced Feature Exploration](#2.3)
        *   [2.3.4 Deep Report Function](#2.3.4)
        *   [2.3.5 ESG Report Generation](#2.3.5)
*   [**Chapter 3: Administrator Guide**](#chapter-3)
    *   [3.1 Installation and Deployment](#3.1)
    *   [3.2 Initial System Configuration](#3.2)
    *   [3.3 Data Source Management](#3.3)
    *   [3.4 User and Security Management](#3.4)
    *   [3.5 Knowledge Base Management](#3.5)
    *   [3.6 System Parameter Configuration](#3.6)
*   [**Chapter 4: Frequently Asked Questions (FAQ)**](#chapter-4)
*   [**Chapter 5: Glossary**](#chapter-5)
*   [**Chapter 6: Technical Support**](#chapter-6)

---

<a id="chapter-1"></a>
## Chapter 1: Product Introduction

<a id="1.1"></a>
### 1.1 What is ZY SmartBI?

ZhanYing ZY SmartBI is a revolutionary conversational business intelligence platform that allows all users, from front-line employees to senior decision-makers, to talk directly with corporate data using natural language to achieve real-time data query, in-depth analysis, and insight discovery.

You don't need to write complex SQL queries or operate cumbersome BI tools. You just need to ask questions as if you were talking to a data analyst, and ZY SmartBI can:
*   **Automatically understand business problems** and accurately locate relevant data.
*   **Generate efficient SQL queries** and retrieve data from the database.
*   **Provide intelligent data visualization** and automatically select the most appropriate charts.
*   **Support multi-turn follow-up questions and drill-down analysis** to explore the root causes of problems.
*   **Proactively discover data anomalies** and provide analytical insights.

<a id="1.2"></a>
### 1.2 Product Vision

Our vision is to create an autonomous AI data analysis partner that connects all corporate data through a unified conversational interface, empowers every employee with the ability to interact with data in-depth and intuitively, seamlessly integrates data-driven decision-making into every corner of the organization, and ultimately improves the operational efficiency and strategic agility of the entire organization.

<a id="1.3"></a>
### 1.3 Who is it designed for?

ZhanYing ZY SmartBI serves every member of the enterprise:

*   **Business decision-makers (such as department managers)**: Can get the core data needed for decision-making in real time without waiting for reports from the data team, and respond quickly to market changes.
    *   *"How was our sales completion rate in each region last quarter?"*
*   **Front-line operations/sales staff**: Can easily monitor daily business indicators, and ask questions and trace the source as soon as they find abnormalities.
    *   *"Is there any abnormality in the user registration volume this morning? Why?"*
*   **Data analysts**: Freed from a large number of repetitive and temporary data extraction requirements, they can devote their valuable time to more valuable in-depth modeling and complex analysis work.
*   **IT/System Administrators**: Efficiently and securely manage data source connections, user permissions, and easily monitor system usage through a unified interface.

---

<a id="chapter-2"></a>
## Chapter 2: User Guide

This chapter is written for the daily users of ZY SmartBI (such as business personnel, operations, sales, marketing, etc.).

<a id="2.1"></a>
### 2.1 Quick Start

#### 1. First Login

1.  Open your browser and visit the login page of ZY SmartBI (for example: `http://127.0.0.1:8000/login`).
2.  Enter your username and password. If you are using it for the first time, your administrator will provide you with initial credentials.
3.  Click the "Login" button.

After successful login, you will be taken to the conversational analysis main interface. It is recommended that you change your password immediately after your first login.

#### 2. Ask Your First Question

In the chat input box, enter the data question you want to know in clear and specific natural language.

**Question examples:**
*   **Simple query**: "Show the total sales for each month of last year."
*   **Comparative analysis**: "Compare the profit margins of products A and B."
*   **Detailed query**: "List the names of all active customers and their last purchase date."
*   **Analysis question**: "Why did the user growth rate decline last month?"
*   **Anomaly detection**: "Is there any anomaly in the recent data?"
*   **Knowledge Q&A**: "What is GMV?"

After entering the question, press the Enter key or click the send button.

#### 3. Understand the Query Results

The system will quickly process your question and display the results in a variety of forms:

1.  **SQL Generation and Explanation**: The system will convert your question into an SQL query and may display the SQL statement for your reference.
2.  **Data Table**: The raw data returned by the query is displayed in a table.
3.  **Data Visualization**: The most appropriate chart (such as a bar chart, line chart, pie chart, etc.) is automatically generated to make the data clear at a glance.
4.  **Analysis and Insights**: For analytical questions, the system will provide structured analysis conclusions and insight summaries.

<a id="2.2"></a>
### 2.2 Core Function Details

#### 1. Multi-turn Dialogue and Context Understanding

ZY SmartBI can understand the context of the conversation, and you can continue to ask questions based on the previous question without repeating the background information.

**Example:**
1.  **You:** "Show the total sales for each month of last year."
2.  **ZY SmartBI:** (displays the sales total chart)
3.  **You:** "What about the profit?" (The system will automatically understand that you are asking about "the total profit for each month of last year")
4.  **ZY SmartBI:** (displays the profit total chart)
5.  **You:** "Only look at the East China region." (The system will further filter the profit data for the East China region)

#### 2. Data Visualization and Interaction

*   **Automatic chart recommendation**: The system automatically selects the most suitable chart type.
*   **Switch chart type**: You can also manually select other chart types (such as bar chart, line chart, pie chart, scatter chart, etc.) from the drop-down menu.
*   **Adjust coordinate axis/scale**: You can manually select the fields used for the X and Y axes, or change the numerical scale of the Y axis (such as linear, logarithmic).
*   **Drill-down**: Drill-down is achieved by asking follow-up questions. For example, after seeing the sales of each region, you can ask "show me the details of the East China region".

#### 3. Dashboards

The dashboard function allows you to aggregate key charts and indicators into one view for centralized monitoring.

*   **View dashboard**: Access the "Dashboard" list from the navigation menu to view the public dashboards you have access to.
*   **Create and layout**:
    1.  Click "New Dashboard" and select a suitable layout template (such as waterfall, cockpit).
    2.  Name the dashboard and add "Items" to the layout.
    3.  Associate a "Source" (a reusable named query) with each item.
    4.  Configure the title, display type, chart details, etc. of each item.
*   **Publish and share**: The created dashboard is in "draft" state by default and is only visible to you. After finishing the design, you can "publish" it to make it visible to other users in the organization (administrator permission may be required).

#### 4. Query History

The system will save all your query records. You can review, reuse, or modify previous queries at any time through the "Query History" function.

#### 5. Export and Share

*   **Export data**: Easily export the table data of the query results to a CSV or Excel file.
*   **Export chart**: Save the chart as an image file (such as PNG).
*   **Share link**: Generate a unique sharing link for any query result. Users with corresponding data permissions can view the results through the link.

<a id="2.3"></a>
### 2.3 Advanced Feature Exploration

#### 1. In-depth Analysis

When you ask open and complex analytical questions, the system will automatically start the in-depth analysis function.

**How to trigger:**
*   "Analyze the root cause of the decline in sales last month."
*   "Explore the purchasing behavior patterns of different user groups."
*   "Predict the product sales trend for the next quarter."

The system will generate a detailed analysis report, including multi-dimensional breakdown, conclusions, charts, and supporting data.

#### 2. Metrics & Monitoring

You can have the system proactively track changes in key business indicators.

**How to configure:**
*   **Configure through dialogue**: "Notify me when the 'active user rate' is lower than 5%."
*   **Configure through the management interface**: Administrators can configure more complex monitoring rules and notification channels.

#### 3. Exploratory and Predictive Analysis

You can ask exploratory or hypothetical questions, and the system will use its analysis model to make inferences and predictions based on existing data.

**Example:**
*   "Explore the main characteristics of high-value customers."
*   "If the product price is increased by 10%, what is the possible impact on sales?" (What-if simulation)

#### 4. Deep Report Function

##### 4.1. Function Overview

The Deep Report function aims to help users conduct in-depth market, industry, or specific topic research through AI, and generate structured, content-rich reports. Unlike traditional data analysis, deep reports can integrate external network information to provide more comprehensive insights.

##### 4.2. Operation Process

The generation of deep reports follows these steps:

1.  **Intent Recognition**: The system first analyzes the user's input to determine if it is a "deep report" intent.
2.  **Clarification of Requirements (Multi-turn Interaction)**: If it is the first time to initiate a deep report request, the AI will actively ask the user 3-5 clarifying questions to help the user refine the research topic and ensure the report's relevance.
3.  **Research Planning**: Based on the user's clear research topic and the answers to the clarifying questions, the AI will generate a detailed research plan, including a series of network search tasks to be executed.
4.  **Information Execution**: The AI executes various search tasks according to the research plan by calling external network search APIs (such as Serper) to collect relevant information.
5.  **Report Synthesis**: The AI filters, integrates, analyzes, and infers all collected information, and finally synthesizes a comprehensive deep research report.
6.  **Save and Notify**: The generated report will be automatically saved to the system, and the user will be notified that the report has been completed.

##### 4.3. How to Trigger a Deep Report

Users can trigger the generation of deep reports in two ways:

##### 4.3.1. Conversational Trigger (Recommended)

In the ChatBI chat interface, directly state your research needs in natural language. The system will automatically identify your question as a "deep report" intent.

**Example**:
*   "Please help me research the competitive landscape of the global electric vehicle market in 2025."
*   "I need an in-depth report on the application prospects of artificial intelligence in the medical field."

After the system identifies the intent, it will actively ask you clarifying questions to guide you to provide more specific requirements. Please answer these questions one by one according to the prompts to ensure the quality and relevance of the report.

##### 4.3.2. Manual Trigger (from the Deep Report page)

You can also directly access the "Deep Report" management page to manually initiate a report generation task.

1.  Log in to the ChatBI system and enter the management backend.
2.  In the left navigation bar, click the "Deep Report" menu item.
3.  In the page top form, enter your research topic.
4.  Click the "Trigger New Report" button.

**Note**: Reports triggered in this way will skip the multi-turn clarification Q&A session. The system will directly conduct research based on the title you entered. Therefore, please ensure that the research topic you entered is specific and clear enough.

#### 4.4. Viewing Deep Reports

All generated deep reports can be viewed on the "Deep Report" management page.

1.  Log in to the ChatBI system and enter the management backend.
2.  In the left navigation bar, click the "Deep Report" menu item.
3.  The page will display a list of all generated reports, including report ID, original question, and generation time.
4.  Click the "View Summary" button next to the report to view a brief summary of the report in a pop-up window.



---

<a id="chapter-3"></a>
## Chapter 3: Administrator Guide

This chapter is written for the system administrators of ZY SmartBI, covering installation, configuration, maintenance, and security management.

<a id="3.1"></a>
### 3.1 Installation and Deployment

Please follow the steps below to install and deploy ZY SmartBI from scratch in a server environment.

#### 1. Environment and Software Package Preparation

*   **Operating System**: Windows 10 or higher.
*   **Hardware**: Recommended 4-core CPU, 8GB RAM, 50GB available disk space.
*   **Core software packages**:
    *   **PostgreSQL**: Latest version recommended (e.g., 17.6).
    *   **Python**: 3.13.6 version recommended.
    *   You can download from the official website or use the link we provide. Please place the downloaded software package in the root directory of the release package.

#### 2. Installation Steps

We provide a series of batch scripts (`.bat`) to simplify the installation process.

*   **Step 1: Install core components**
    *   Double-click to run the `Install ZhanYing AI Smart Business.bat` script to install the core components.
    *   Double-click to run the `Install python.bat` script to install the Python environment and dependent libraries required by ZY SmartBI.
    *   **Important**: After installing PostgreSQL, please run `services.msc` to open the service manager, find the `postgresql` service, and set its startup type to "Automatic".

*   **Step 2: Configure environment variables (`.env` file)**
    1.  In the project root directory, find the `.env.example` file, copy and rename it to `.env`.
    2.  Use a text editor to open the `.env` file and configure the following key information:
        *   **Database connection (for storing ZY SmartBI's own metadata)**:
            ```env
            DB_USER=postgres
            DB_PASSWORD=ZYCBI2025 # Please change to your PostgreSQL password
            DB_HOST=127.0.0.1
            DB_PORT=5432
            DB_NAME=chatbi_forge_dev
            ```
        *   **Administrator account (created on first startup)**:
            ```env
            DEFAULT_ADMIN_USERNAME=admin
            DEFAULT_ADMIN_PASSWORD=admin1
            ```
        *   **Debug login (optional)**:
            ```env
            # Set to True to log in with any password, for development and testing environments only
            LOGIN_DEBUG=True 
            ```
        *   **LLM API Key (at least one must be configured)**:
            ```env
            DEEPSEEK_API_KEY=your_deepseek_api_key_here
                        DASHSCOPE_API_KEY=your_dashscope_api_key_here
            ```

*   It is recommended to use Kimi K2 instead of DeepSeek.
            ```

*   **Step 3: Initialize data**
    *   Double-click to run the `Initialize data.bat` script.
    *   This script will connect to the database you configured in the `.env` file and create the table structure and sample data required by ZY SmartBI.

*   **Step 4: Start the service**
    *   Double-click to run the `Run ZY chatBI.bat` script.
    *   The service takes about 40 seconds to start. After successful startup, you can access the system through your browser.

#### 3. Access the system

*   **User login**: `http://127.0.0.1:8000/login`
*   **Dialogue interface**: `http://127.0.0.1:8000/chat`
*   **Administrator interface**: `http://127.0.0.1:8000/admin/dashboard`

<a id="3.2"></a>
### 3.2 Initial System Configuration

After the system is running for the first time, please complete the following core configurations as an administrator.

1.  **First login to the administrator account**
    *   Visit `http://127.0.0.1:8000/login`.
    *   Log in with the default credentials (username: `admin`, password: `admin1`).
    *   After logging in, it is strongly recommended that you immediately navigate to the user management module to change the default administrator's password.

2.  **Connect to the first business data source**
    *   In the management interface, navigate to "Data Source Management".
    *   Click "Add New Data Source", fill in the unique name of the data source, select the database type, and fill in the connection parameters.
    *   Click "Test Connection" to verify the configuration, and then save the data source.

3.  **Import and enrich metadata**
    *   Navigate to the "Metadata Management" page and select the newly added data source.
    *   Click the "Import Data Source Metadata" button to import the table and column information of the database into the system.
    *   **(Recommended)** Click the "AI Auto-generate Metadata" button to let AI automatically generate business descriptions, synonyms, etc. for tables and columns, which will greatly improve the accuracy of subsequent natural language to SQL.

4.  **Create the first user and role**
    *   Navigate to "Role and Permission Management", create a new role (such as `Sales_Analyst`), and assign access permissions to the data source for this role.
    *   Navigate to "User Management", create a new user, and assign them to the `Sales_Analyst` role.

<a id="3.3"></a>
### 3.3 Data Source Management

#### Supported Data Source Types

ZY SmartBI supports connecting to a variety of mainstream databases, including POSTGRESQL, MYSQL, SQLSERVER, ORACLE, CLICKHOUSE, SNOWFLAKE, BIGQUERY, etc. (The basic experience version currently only supports connecting to POSTGRESQL, MYSQL, and SQLSERVER databases. For support for other database types, please contact us for the standard version).

#### Manage Data Sources

On the "Data Source Management" page, you can perform operations on added data sources:
*   **Add**: Connect to a new business database.
*   **Edit**: Modify the connection parameters or name of the data source.
*   **Delete**: Remove the connection information of the data source from ZY SmartBI.
*   **Refresh metadata**: When the business database structure changes, you need to re-import the metadata.

#### Advanced Metadata Management

On the metadata management page of the data source, you can use AI enhancement functions:
*   **AI Generate Descriptions and Logic (`Generate Metadata`)**: The core function uses LLM to analyze the table structure and data, automatically fills in business descriptions, synonyms, and generates "selection logic" to guide AI to select tables more intelligently.
*   **Clear AI-generated descriptions (`Clear Descriptions`)**: Remove all AI-generated descriptions and synonyms.
*   **Delete all metadata (`Delete All Metadata`)**: Completely delete all metadata records of this data source in ZY SmartBI, which is used for reconstruction after major changes in the data source structure.

<a id="3.4"></a>
### 3.4 User and Security Management

#### User Management
In the "User Management" interface, you can:
*   **Create a new user**: Set username, initial password, and status.
*   **Edit user**: Modify user information, such as resetting password, disabling account.
*   **Delete user**: Permanently remove a user account.

#### Role Management (RBAC - Role-Based Access Control)

ZY SmartBI implements a Role-Based Access Control (RBAC) model, which simplifies user permission management by assigning permissions to roles and then assigning roles to users. Roles are a collection of permissions, which simplifies permission management through the "role -> user" model.
*   **Create a new role**: Define a role name (such as `Sales_Analyst`, `HR_Viewer`).
*   **Assign permissions**: Assign accessible **data sources** and usable **functions** to roles.
*   **Assign roles to users**: Select one or more roles for a user on the user editing page.

#### Data Permission Control (RLS & CLS)

To ensure data security and privacy, ZY SmartBI provides powerful Row-Level Security (RLS) and Column-Level Security (CLS) features, allowing administrators to finely control user access to data.

*   **Row-Level Security (RLS)**: Restrict users to access only specific rows in a table. For example, a sales manager can only see the sales data of their own team.
*   **Column-Level Security (CLS)**: Restrict users to access only specific columns in a table. For example, non-HR users cannot see the salary column.
*   RLS and CLS policies are advanced functions, usually defined in the role permission configuration for specific data tables by defining row filtering conditions or specifying a list of accessible columns.

#### PII Data Anonymization

To protect sensitive data, the system has a built-in PII (Personally Identifiable Information) anonymization function.
*   **Enable/disable**: `PII_SCRUBBING_ENABLED` can be enabled globally in the system configuration.
*   **Configure rules**: Administrators can configure PII identification rules (such as defining email, phone number, etc. patterns through regular expressions) in the background.

#### Audit Log

The system will record key user operations (such as login, query, configuration changes) and system events. Administrators can view these records in the "Audit Log" module for security auditing and problem tracking.

<a id="3.5"></a>
### 3.5 Knowledge Base Management

The knowledge base is an important part of the ZY SmartBI RAG (Retrieval-Augmented Generation) service. It provides additional business context for the LLM to improve query accuracy.

#### What is a knowledge base?

A knowledge base can contain:
*   **Business rules**: Calculation logic for specific indicators, business process descriptions.
*   **Data dictionary**: More detailed business explanations of tables and columns.
*   **Historical query examples**: Successful "question-SQL" pairs as AI learning samples.
*   **Other documents**: Product manuals, FAQs, company reports, etc.

#### Manage Knowledge Base

1.  **Configure knowledge base source file directory**: Store knowledge documents (supporting Markdown, TXT, PDF, etc.) in a specific directory on the server, and add the directory as a knowledge source in the management interface.
2.  **Knowledge base indexing**: After adding or modifying the source file, you need to trigger the "indexing" operation. The system will scan the file, process it into a vector, and store it in the vector database. This operation can be manually triggered in the management interface.
3.  **Maintenance**:
    *   **Clear knowledge base**: Delete all indexed documents in the vector database.
    *   **Delete a single document**: Remove a specific indexed file based on the document ID.

<a id="3.6"></a>
### 3.6 System Parameter Configuration

ZY SmartBI adopts layered configuration. **Database configuration (set through the management interface) has a higher priority than environment variables (`.env` file)**. Configurations modified through the management interface can take effect immediately.

#### Configure through the management interface (recommended)

*   **Access path**: `Management` -> `System Settings`.
*   **Configurable items**:
    *   **AI provider settings**: Manage the API keys and Base URLs of major model services.
    *   **System prompt template**: Customize the prompt word templates used by the system to interact with the LLM in different scenarios (such as knowledge Q&A, clarification questions, fallback).

#### Configure through the .env file (backup/initial)

After modifying the `.env` file, you **must restart the service** for it to take effect.

*   **Database configuration (`DB_*`)**: Connection information for the internal metadata database of ZY SmartBI.
*   **Vector database (`VECTOR_STORE_PATH`)**: Storage path of the ChromaDB vector database.
*   **LLM service configuration (`OPENAI_API_KEY`, `LLM_TEMPERATURE`, etc.)**: Configure the API Key, model name, temperature, and other parameters of major model services.
*   **Security and privacy (`SECRET_KEY`, `LOGIN_DEBUG`, `PII_SCRUBBING_ENABLED`)**: Configure security keys, debug mode, and PII anonymization switch.
*   **Log and monitoring (`LOG_LEVEL`, `LOG_FILE_PATH`)**: Configure log level and output file path.
*   **Other (`MAX_CONCURRENT_QUERIES`, `MAX_CONVERSATION_HISTORY_MESSAGES`, etc.)**: Configure performance and functional parameters such as the number of concurrent queries and the length of conversation history.

---

<a id="chapter-4"></a>
## Chapter 4: Frequently Asked Questions (FAQ)

### Login and Account
*   **Q: What should I do if I forget my password?**
    *   **A:** Please contact your system administrator to reset your password.
*   **Q: Why can't I log in, and it says "Account locked"?**
    *   **A:** Multiple incorrect password attempts will temporarily lock your account. Please wait a while and try again, or contact your administrator to unlock it.

### Query and Data
*   **Q: Why is my query result empty?**
    *   **A:** Possible reasons include: the data itself does not exist, you do not have permission to access the data, the question is too vague, or there is a problem with the back-end data source connection. Please check one by one or contact your administrator.
*   **Q: Why is my query so slow?**
    *   **A:** Query speed is affected by many factors, such as data volume, query complexity, database performance, and current system load.
*   **Q: What should I do if the system cannot understand my question?**
    *   **A:** Try to simplify the question, use more standard business terms, provide more context, or check for typos.

### Reports and Visualization
*   **Q: Can I customize the chart?**
    *   **A:** Yes. After the chart is generated, you can usually switch the chart type, adjust the X/Y axis fields, change the scale, etc. to meet your personalized analysis needs.

---

<a id="chapter-5"></a>
## Chapter 5: Glossary

### Business Terms
*   **Dimension**: The perspective of analyzing data, usually text type, such as "region", "product category".
*   **Metric**: A numerical value used to measure business performance, usually a number type, such as "sales", "order volume".
*   **Insight**: A valuable and actionable conclusion discovered from data.
*   **Drill-down**: The analysis process of going from macroscopic data to more granular microscopic data.
*   **Root Cause Analysis (RCA)**: Find the root cause of a phenomenon (such as a decline in an indicator).

### Technical Terms
*   **LLM (Large Language Model)**: The AI core that drives ZY SmartBI to understand and generate language.
*   **RAG (Retrieval-Augmented Generation)**: Before answering a question, the system first retrieves relevant information from the knowledge base, and then generates a more accurate answer based on this information.
*   **Metadata**: "Data about data", including table names, column names, data types, business descriptions, etc., is the basis for ZY SmartBI to understand your data structure.
*   **PII (Personally Identifiable Information)**: Sensitive data such as name, phone number, email, etc.
*   **RBAC (Role-Based Access Control)**: A security model that efficiently manages user permissions.

---



<a id="chapter-6"></a>
## Chapter 6: Technical Support

If you encounter any problems or have any suggestions during use, please contact us in the following ways:

*   **Company Name**: Shenzhen Zhanying Technology Co., Ltd.
*   **Official Website**: zyinfo.pro
*   **WeChat Contact**: youkpan
*   **Technical Support Email**: pyq@zyinfo.pro

Thank you for choosing ZhanYing ZY SmartBI, let's start a new era of data-driven decision-making together!