# ZY SmartBI Business Glossary

This glossary aims to explain some of the common business and technical terms used within the ZY SmartBI platform, helping users to better understand system functions and data analysis concepts.

---

## Business-Related Terms

### Dimension

*   **Definition**: An attribute used to describe, categorize, or group data. Dimensions are typically qualitative, such as "Product Name," "Region," "Date," "Customer Type," etc. They are the "perspectives" from which you analyze your data.
*   **Example**: In sales data, "Product Category" is a dimension, and you can view sales figures by product category.

### Metric

*   **Definition**: A numerical value used to measure or quantify business performance. Metrics are typically quantitative and can be aggregated, such as "Sales Amount," "Profit," "Order Volume," "User Count," etc.
*   **Example**: In sales data, "Sales Amount" is a metric, and you can calculate the sum, average, etc., of sales across different dimensions.

### Insight

*   **Definition**: A valuable, actionable discovery or conclusion found from data analysis. An insight is not just the data itself, but the business meaning and trends revealed by the data.
*   **Example**: Discovering that "website traffic is highest on Tuesday afternoons, but the conversion rate is lowest" is an insight, which might suggest a need to optimize marketing strategies for Tuesday afternoons.

### Drill-down

*   **Definition**: The process in data analysis of moving from a high-level, summary view to a more detailed, granular view. In ZY SmartBI, drill-down is typically achieved through follow-up questions in a multi-turn conversation, rather than clicking on chart elements.
*   **Example**:
    1.  First ask: "Show sales by region."
    2.  Then ask: "Let's look at the details for the East China region," to drill down into city or product sales details for that region.

### Aggregation

*   **Definition**: The process of summarizing multiple rows of data into a single row or a few summary rows. Common aggregation operations include SUM, AVG (average), COUNT, MAX (maximum), MIN (minimum), etc.
*   **Example**: Calculating the "total sales" for all products or the "average order value."

### Root Cause Analysis (RCA)

*   **Definition**: A systematic problem-solving method aimed at identifying and addressing the fundamental cause of a problem, rather than just treating its symptoms. In ZY SmartBI, it refers to the system helping users identify the main factors behind an anomalous metric by analyzing data.

### What-if Simulation

*   **Definition**: A predictive analysis technique that involves changing one or more input variables to observe the potential impact of these changes on the output results. It is used to evaluate potential outcomes under different scenarios.

### Proactive Insights

*   **Definition**: The ability of the system to automatically monitor key business metrics and proactively send notifications or provide analytical suggestions to users when it detects anomalies, important trends, or when preset conditions are met.

### Dashboard

*   **Definition**: An integrated view that displays multiple related charts, metrics, and data summaries. Dashboards help users quickly monitor the performance of key business areas.
*   **Example**: Creating a "Sales Performance Dashboard" that includes a monthly sales trend chart, a comparison chart of sales by region, and KPI cards for key product sales.

### Dashboard Item

*   **Definition**: A single visual element within a dashboard, such as a chart, a KPI card, or a table.

### Dashboard Source

*   **Definition**: A reusable, named query that provides data for a dashboard item. It is typically an SQL query that defines how to extract specific data from the database.

---

## Technical-Related Terms

### Natural Language Processing (NLP)

*   **Definition**: A branch of artificial intelligence that aims to enable computers to understand, interpret, and generate human language. ZY SmartBI uses NLP to understand your natural language questions.

### Large Language Model (LLM)

*   **Definition**: An AI model based on deep learning, trained on massive amounts of text data, capable of understanding, generating, and processing human language. ZY SmartBI uses an LLM to convert natural language questions into SQL queries.

### Retrieval-Augmented Generation (RAG)

*   **Definition**: A technique that combines information retrieval with text generation. In ZY SmartBI, RAG is used to retrieve relevant information from project metadata and knowledge bases (such as table structures, business rules, historical query examples), and then provide this information as context to the LLM to improve the accuracy and relevance of the generated SQL.

### SQL (Structured Query Language)

*   **Definition**: A standard programming language used for managing relational databases. ZY SmartBI converts your natural language questions into SQL statements to retrieve data from the database.

### Metadata

*   **Definition**: Data about data. In ZY SmartBI, metadata includes database table names, column names, data types, descriptions, business meanings, etc. This information helps the system understand the structure and content of the data.

### Vector Database

*   **Definition**: A database specifically designed for storing, managing, and retrieving vector embeddings. In ZY SmartBI, a vector database (like ChromaDB) is used to store the embeddings of metadata and knowledge bases for efficient similarity searches, supporting the RAG feature.

### PII (Personally Identifiable Information)

*   **Definition**: Information that can be used on its own or with other information to identify, contact, or locate a single person. In ZY SmartBI, the system performs PII masking to protect user privacy and data security.

### RBAC (Role-Based Access Control)

*   **Definition**: A security model that grants or restricts access to system resources based on a user's role within an organization.

### RLS (Row-Level Security)

*   **Definition**: A database security feature that restricts user access to specific rows in a database table based on user identity or other conditions. It ensures that users can only see the data they are authorized to view.