# ZY SmartBI Frequently Asked Questions (FAQ)

This section collects common questions and their answers that ZY SmartBI users may encounter. If your question is not listed here, please contact your system administrator or technical support.

## 1. Login and Account

### Q1.1: What should I do if I forget my password?

**A:** Please contact your system administrator to reset your password. The system does not currently support a self-service password reset feature for users.

### Q1.2: Why can't I log in, with a message saying "Account is locked"?

**A:** This is usually caused by entering the wrong password multiple times. For security, the system automatically locks accounts after several failed attempts. Please wait a while before trying again, or contact your system administrator to unlock your account.

### Q1.3: I am a system administrator. How can I bypass password verification during development or testing?

**A:** (Admin only) You can set `LOGIN_DEBUG` to `True` in the system's `.env` configuration file. When enabled, the system will allow logging in with any password for a given username, which is very useful during development and testing.
**Please note: This is a serious security risk. Make sure to set it to `False` in a production environment.**

## 2. Queries and Data

### Q2.1: Why are my query results empty?

**A:** There could be several reasons:
*   **Data does not exist:** The conditions you queried may not have matching data in the database.
*   **Insufficient permissions:** You may not have permission to access the relevant data. Please contact an administrator to confirm your data access rights.
*   **Unclear question:** Your question might be too vague for the system to understand accurately. Try describing your needs more specifically.
*   **Data source not connected/updated:** The relevant business data source may not be connected or the data may not be up to date. Please contact an administrator.

### Q2.2: Why is my query so slow?

**A:** Query speed is affected by several factors:
*   **Data volume:** The larger the amount of data being queried, the longer it will take.
*   **Query complexity:** Complex aggregations, joins, or subqueries increase execution time.
*   **Data source performance:** The performance of the backend database, network latency, etc., will affect query speed.
*   **System load:** During peak hours, the system may be handling a large number of concurrent requests, leading to slower responses.
*   **Network issues:** An unstable network connection on your end can also lead to perceived delays.

### Q2.3: What should I do if the system can't understand my question?

**A:**
*   **Simplify the question:** Try breaking down a complex question into several simpler ones.
*   **Use business terminology:** Use business terms and metric names that are common in your industry or company.
*   **Provide more context:** In a multi-turn conversation, ensure you have provided enough contextual information.
*   **Check for typos:** Make sure your question does not have obvious spelling or grammatical errors.
*   **Contact an administrator:** If the problem persists, please provide feedback to an administrator. They can help you optimize your questions or check the system configuration.

### Q2.4: What data can I query?

**A:** The data you can query depends on your account permissions and the data sources that have been connected and configured in the system. Typically, the system grants you access to relevant business data based on your role and department. If you need access to more data, please contact your administrator.

## 3. Reports and Visualization

### Q3.1: Why does the chart I see look different from someone else's?

**A:** This could be due to the following reasons:
*   **Data permissions:** Your data access rights may differ from others, causing you to see a different subset of data.
*   **Personalized settings:** You may have saved different report or dashboard views.
*   **Time range:** Ensure that you and the other person are querying the same time range.

### Q3.2: Can I customize the charts?

**A:** Yes. After generating a chart, ZY SmartBI provides a rich set of customization options:
*   **Switch chart type**: You can select other chart types (such as bar, line, pie, scatter, etc.) from a dropdown menu, building on the system's recommendation.
*   **Adjust axes**: For charts with axes (like line or bar charts), you can manually select the fields to be used for the X and Y axes.
*   **Change scale**: For line charts, you can also change the numerical scale of the Y-axis (e.g., linear, logarithmic) to better observe data trends.
These options allow you to flexibly adjust the visualization to meet your analytical needs.

## 4. Other

### Q4.1: How can I get information about the latest feature updates?

**A:** Please pay attention to system announcements or check the [Release Notes](docs/admin/07_release_notes.md) (if made public by the administrator).

### Q4.2: I have a suggestion for a new feature. Who should I give feedback to?

**A:** We very much welcome your suggestions! Please submit your feature suggestions through internal communication channels or by contacting your system administrator.