# ZY SmartBI Advanced Features Guide

This guide will walk you through the advanced features of ZY SmartBI, helping you to mine deeper insights from your data and perform more complex analyses.

## 1. In-depth Analysis

When simple queries don't meet your needs, you can use the in-depth analysis feature. ZY SmartBI's AI analysis engine can automatically generate a multi-step analysis plan based on your question and execute it to find the answer.

**How to trigger in-depth analysis:**

You can trigger this feature by asking more open-ended and complex analytical questions:

*   "Analyze the root cause of the sales decline last month."
*   "Explore the purchasing behavior patterns of different user segments."
*   "Predict the product sales trend for the next quarter."

The system will automatically recognize your intent and start the analysis process. Upon completion, it will generate a detailed analysis report containing conclusions, charts, and supporting data.

## 2. Metrics & Monitoring

You can define and manage key metrics for your business and set up monitoring tasks so that the system can proactively track changes in these metrics.

### 2.1 Defining Metrics

You can provide the system with the calculation formulas and business meanings of the metrics you care about. For example:
*   **Metric Name:** `Active User Rate`
*   **Calculation Formula:** `COUNT(DISTINCT user_id) / (SELECT COUNT(*) FROM users)`
*   **Business Meaning:** `Measures the user activity of the product within a specific time frame.`

### 2.2 Setting up Monitoring

Once a metric is defined, you can set up a monitoring task to have the system notify you when the metric reaches a certain threshold.

**How to configure monitoring:**

1.  **Configure via Conversation:** You can tell ZY SmartBI which metric and condition you want to monitor. For example: "Notify me when the 'Active User Rate' falls below 5%."
2.  **Configure via Admin Interface:** Administrators can configure more complex monitoring rules and notification channels (such as email, SMS, or in-app notifications) in the backend.

## 3. Knowledge Base Management

To make ZY SmartBI better understand your business, you can add your own business documents, product manuals, market analysis reports, etc., to the system's knowledge base. The system will learn from this knowledge and provide more accurate answers by incorporating this information when responding to your questions.

**How to manage the knowledge base:**

*   **Add Knowledge Source:** In the system settings, you can specify one or more directories containing knowledge documents.
*   **Trigger Indexing:** After adding a new knowledge source, you can manually trigger an indexing process to make the system learn the new content.
*   **Knowledge Base Search:** You can directly ask the knowledge base questions in the chat, for example: "What is our return policy?"

## 4. Exploratory and Predictive Analysis

In addition to analyzing historical data, you can also use ZY SmartBI's in-depth analysis capabilities to ask exploratory or predictive questions. The system will use its analytical models to make inferences and predictions based on existing data.

**How to perform exploratory analysis:**

You can ask open-ended questions to have the system explore potential relationships and patterns in the data:

*   "Explore the purchasing behavior patterns of different user segments."
*   "What are the main characteristics of high-value customers?"
*   "If the product price is increased by 10%, what might be the impact on sales?"

ZY SmartBI will attempt to provide you with simulated prediction results and insights based on historical data and relevant factors to help you make decisions. Please note that these predictions are inferences based on existing data and are not guaranteed to be 100% accurate.

## 5. Next Steps

You have now mastered the advanced analysis capabilities of ZY SmartBI. By flexibly using these features, you can gain a deeper understanding of your business data and make more informed decisions.

If you encounter any problems while configuring or using advanced features, please refer to the [Frequently Asked Questions (FAQ)](04_faq.md) or contact your administrator.