# ZY SmartBI Core Features Guide

This guide provides a detailed introduction to the core features of ZY SmartBI, helping you to use the platform more deeply for data analysis and insights.

## 1. Multi-turn Conversation and Context Understanding

ZY SmartBI can understand the context of multi-turn conversations through advanced intent recognition and context management. This means that after asking an initial question, you can continue to ask related follow-up questions without having to repeat previous conditions or entities.

**Example:**

1.  **You:** "Show the total sales for each month of last year."
2.  **ZY SmartBI:** (Displays a chart and data for total sales)
3.  **You:** "What about the profit?" (The system will automatically understand you are asking for "the total profit for each month of last year")
4.  **ZY SmartBI:** (Displays a chart and data for total profit)

**Tips:**
*   Use pronouns (like "it", "that") or omit the subject to refer to entities mentioned in the previous turn.
*   Clearly state the condition you want to change, for example: "Only show sales for the East China region."

## 2. Data Visualization and Interaction

ZY SmartBI automatically selects the most appropriate visualization chart based on the query results. You can interact with these charts to gain a deeper understanding.

### 2.1 Chart Types

Common chart types include:
*   **Bar Chart/Column Chart**: Suitable for comparing data across different categories.
*   **Line Chart**: Suitable for showing trends in data over time.
*   **Pie Chart/Doughnut Chart**: Suitable for showing the relationship of parts to a whole.
*   **Table**: Displays raw data, supporting sorting and pagination.
*   **KPI Card**: Used to display a single value for a key performance indicator.

### 2.2 Chart Interaction

*   **Switching Chart Types**: In some cases, the system may offer multiple chart types for you to choose from. You can switch between them using options on the interface.
*   **Drill-down**: For some dimensional data, you can click on elements within the chart (e.g., a bar in a bar chart), and the system will prompt you if you want to "drill down" to a more granular dimension. For example, drilling down from "regional sales" to "city sales".
*   **Filtering**: You can further filter the data through conversation or by using filters on the interface. For example: "Only show products with sales exceeding 1 million."

## 3. Dashboards

ZY SmartBI offers powerful dashboard functionality, allowing you to aggregate key charts and metrics into a single view for centralized monitoring and analysis.

### 3.1 Viewing Dashboards

You can access the "Dashboard" list from the navigation menu to see all dashboards you have access to, including those you've created yourself and public dashboards published by others.

### 3.2 Creation and Layout

1.  **Create Dashboard**: On the dashboard page, click the "New Dashboard" button to start creating your personalized dashboard.
2.  **Choose Layout**: The system provides several preset professional layout templates to suit different analysis scenarios:
    *   **Waterfall Layout**: Suitable for free exploration and displaying multiple charts of varying sizes.
    *   **Cockpit Layout**: A structured layout, typically used for centrally monitoring core metrics, suitable for management cockpit scenarios.
    You can choose a suitable layout template for your new dashboard.
3.  **Design and Configuration**:
    *   **Naming and Adding Items**: Name your dashboard and add new "Items" to the layout.
    *   **Associate Data Source**: Each item needs to be associated with a "Source". A source is a reusable, named SQL query. You can select from existing sources or save a new query result from the conversational analysis as a source.
    *   **Configure Item**: You can configure the title, default display type (e.g., chart, KPI card), importance (core/secondary/auxiliary), and specific chart configurations (e.g., X/Y axis, colors) for each item.
4.  **Save and Publish**: Once you've finished editing, click "Save Dashboard".

### 3.3 Publishing and Sharing

*   **Draft and Publish**: Dashboards you create are in a "Draft" state by default, visible only to you. After finalizing the design, you can "Publish" it to make it visible to other users in your organization.
*   **Permission Note**: Publishing and unpublishing dashboards typically require administrator privileges.

The dashboard feature enables you to solidify your routinely monitored data points into a personalized or team-shared data monitoring center.

## 4. Query History

You can use the query history feature to view your previously asked questions and the system's responses. This helps you to:

*   Review your previous analysis process.
*   Reuse or modify previous queries.
*   Share your analysis findings with colleagues.

You can find the "Query History" entry in a designated area of the system, usually displayed as a list that supports searching and filtering.

## 5. Exporting and Sharing

You can easily export query results or charts for use in other reports or presentations.

*   **Export Data**: Options to export data in CSV or Excel format are usually available.
*   **Export Chart**: Charts can be saved as image files (e.g., PNG, JPEG) or PDFs.
*   **Share Link**: For any query result, you can generate a unique, shareable link. Users with the link and the appropriate data permissions can access it to view your query results and charts. The shared link re-executes the query upon access to ensure data freshness and security.

## 6. Common Issues and Optimization Tips

*   **Unclear Questions**: If your question is too vague, ZY SmartBI may ask for more information. For example, for "What are the sales?", the system might ask, "For which time period?" or "For which product?"
*   **Use Business Terminology**: Try to use terms and metric names that are common in your business, as this helps ZY SmartBI understand your intent more accurately.
*   **Ask Step-by-Step**: For complex questions, try breaking them down into smaller, sequential questions to refine your request.

## 7. Next Steps

You have now mastered the core features of ZY SmartBI. If you wish to explore more advanced data analysis capabilities, such as anomaly detection, root cause analysis, proactive insights, or more complex permission management, please refer to the [Advanced Features Guide](03_advanced_features_guide.md).

If you encounter any issues during use, please refer to the [Frequently Asked Questions (FAQ)](04_faq.md) or contact your administrator.