# ZY SmartBI User Quick Start Guide

Welcome to ZY SmartBI! This guide will help you log in for the first time, ask your first question, and gain data insights in just a few minutes.

## 1. What is ZY SmartBI?

ZY SmartBI is a powerful conversational business intelligence (BI) platform that allows you to interact with your enterprise data using natural language. Without needing complex SQL knowledge, you can simply ask questions, and ZY SmartBI will generate SQL queries, visualize data, and provide intelligent analysis for you. It supports advanced analytical capabilities like multi-turn conversation, data drill-down, anomaly detection, and root cause analysis to help you extract deeper insights from your data.

## 2. First-time Login and Main Interface

1.  Open your browser and go to the ZY SmartBI login page: `http://127.0.0.1:8000/login`.
2.  If you are a first-time user or using the default configuration, enter the administrator account:
    *   **Username:** `admin`
    *   **Password:** `admin1`
3.  Click the "Login" button.

After a successful login, you will be directed to different main interfaces based on your user role:
*   **Conversational Analytics (Chat BI):** This is the core interface (`/chat`) accessible to all users, where you can interact with data by asking questions in natural language.
*   **Dashboard:** Here you can view and create data dashboards (`/data_dashboard`) to centrally monitor key metrics.
*   **Admin Backend:** Accessible to admin users (`/admin/dashboard`), it is used for managing data sources, users, knowledge bases, and system settings.

It is recommended to change the default password immediately after your first login.

## 3. Asking Your First Question

In the chat input box, type the data question you want to query or analyze. Try to use clear and specific natural language. For example:

*   "Show the total sales for each month of last year."
*   "Which region had the highest profit in 2023?"
*   "List the names of all active customers and their last purchase date."
*   "Why did the user growth rate decline last month?" (Analysis question)
*   "Are there any anomalies in the recent data?" (Anomaly detection)
*   "What is GMV?" (Knowledge question)

After typing your question, press Enter or click the send button.

![Example of asking a question](images/ask_question_example.png)

## 4. Understanding the Query Results

After receiving your question, ZY SmartBI will perform the following steps and display the results:

1.  **SQL Generation and Explanation**: The system converts your natural language question into an executable SQL query and provides a brief explanation. You can usually see the generated SQL statement in the results area (if enabled).
2.  **Data Table**: After the SQL query is executed, the raw data is displayed in a table format. You can view the specific values for each row and column.
3.  **Data Visualization**: ZY SmartBI automatically generates the most appropriate chart (such as a bar chart, line chart, pie chart, etc.) based on the type of query result to help you understand the data more intuitively.
4.  **Analytical Insights**: For analysis-type questions, ZY SmartBI provides structured analysis results and insights.

![Example of results display](images/results_example.png)

## 5. Gaining Data Insights

By viewing the data table and visualization chart, combined with your initial question, you can quickly obtain the data insights you need. For example, from a line chart of total sales, you can see the sales trend at a glance; from a bar chart of regional profits, you can quickly identify the best-performing regions.

## 6. Next Steps

Congratulations! You have successfully completed your first experience with ZY SmartBI. To learn about more advanced features, such as multi-turn conversation, data drill-down, anomaly detection, root cause analysis, and how to use ZY SmartBI for more in-depth analysis, please refer to the [Core Features Guide](02_core_features_guide.md).