# ZY SmartBI Release Notes

This document records the release details for each version of ZY SmartBI, including new features, improvements, bug fixes, and any important changes. Please review this document regularly to stay updated on the system's latest developments.

---

## Version: 1.0.0 (MVP)

*   **Release Date**: August 2, 2025
*   **Main Goal**: Implement the core conversational BI features of ZY SmartBI and validate technical feasibility.

### New Features

*   **Natural Language Query**: Supports users asking questions in natural language, which the system converts into SQL queries.
*   **Multi-turn Conversation**: Supports multi-turn follow-up questions based on context, understanding user intent.
*   **Data Visualization**: Automatically generates basic visualization types such as bar charts, line charts, pie charts, and tables.
*   **Data Source Connection**: Supports connecting to relational databases like SQLite, PostgreSQL, and MySQL.
*   **Metadata Management**: Automatically scans and manages metadata for data sources, including tables and columns.
*   **LLM Abstraction Layer**: Supports integration with various large language model services, including OpenAI, Anthropic, Google Gemini, and DeepSeek.
*   **PII Masking**: Automatically masks sensitive data before sending it to external LLM services.
*   **User Authentication**: Basic username/password login functionality.

### Improvements and Optimizations

*   **Performance Optimization**: Improved response speed for Text2SQL conversion and data querying.
*   **User Experience**: Optimized the fluidity of the chat interface interaction.

### Bug Fixes

*   Fixed issues with inaccurate SQL generation under specific complex queries.
*   Fixed issues with abnormal display of some charts.

### Known Issues

*   Complex data write operations are not yet supported.
*   Advanced permission management (e.g., fine-grained RLS/CLS configuration) is still under development.

---

## Version: 1.1.0 (Planned)

*   **Release Date**: To be determined
*   **Main Goal**: Enhance enterprise-grade features, improve security and manageability.

### New Features

*   **Advanced Permission Management**: Improved web interface configuration for RBAC and RLS/CLS.
*   **Audit Logs**: Comprehensive logging of user operations and system events, providing traceable audit logs.
*   **Proactive Insights**: Supports configuring key metric monitoring and anomaly notifications.
*   **Knowledge Base Management**: Provides a web interface for managing knowledge base source files and triggering indexing.
*   **What-if Simulation**: Initial support for hypothetical analysis based on user input.

### Improvements and Optimizations

*   Improved stability and accuracy of LLM responses.
*   Optimized data source connection compatibility.

### Bug Fixes

*   To be determined

---

## How to Get Updates

Please contact your system administrator for the latest ZY SmartBI deployment package or update guide.

## Feedback and Support

If you encounter any issues or have any suggestions during use, please contact us via:

*   **Technical Support Email**: support@ZY SmartBI.com
*   **Internal Feedback Channel**: [Link to your internal feedback system]
