# ZY SmartBI Knowledge Base Management Guide

This guide aims to instruct ZY SmartBI system administrators on how to effectively manage the knowledge base. The knowledge base is a crucial component of ZY SmartBI's RAG (Retrieval-Augmented Generation) service, providing additional contextual information to the LLM to improve query accuracy and relevance.

## 1. What is a Knowledge Base?

A knowledge base is a collection of data used by ZY SmartBI to enhance its understanding and generation capabilities. It typically includes:

*   **Business Rules**: For example, calculation logic for specific metrics, business process descriptions.
*   **Data Dictionary**: More detailed, business-oriented descriptions of tables and columns.
*   **Historical Query Examples**: Successful cases of user questions and corresponding SQL, serving as few-shot learning samples for the LLM.
*   **Other Documents**: Such as product manuals, FAQs, internal company reports, etc., which can supplement the LLM's ability to answer knowledge-based questions.

Content in the knowledge base is processed into vector embeddings and stored in a vector database for retrieval by the RAG service.

## 2. Knowledge Base Source File Management

Knowledge base content typically exists as files in the file system. Administrators need to specify the storage location of these files.

### 2.1 Configuring Knowledge Base Source File Directories

1.  **Prepare Source Files**: Organize your business rules, data dictionaries, historical query examples, and other documents into supported formats (e.g., Markdown, TXT, PDF) and store them in a directory on the server.
    *   **Recommendation**: Create separate subdirectories for different types of knowledge base content, for example:
        ```
        /knowledge_base
        ├── /business_rules
        ├── /data_dictionary
        └── /query_examples
        ```
2.  **Add Knowledge Source Directory to ZY SmartBI**:
    *   You can add knowledge source directories via the administrator web interface or by directly calling the API.
    *   **API Example**: `POST /api/v1/knowledge/directories`
        *   **Request Body**: `{"name": "Business Rules", "path": "/path/to/your/knowledge_base/business_rules", "description": "Company business rules documentation"}`
    *   **Note**: Ensure that the user running the ZY SmartBI service has read permissions for these directories.

## 3. Knowledge Base Indexing

The process of converting knowledge base source files into vector embeddings and storing them in a vector database is called "indexing." Only indexed knowledge base content can be retrieved by the RAG service.

### 3.1 Manually Triggering Indexing

After you add, modify, or delete knowledge base source files, you need to manually trigger an index update to ensure ZY SmartBI uses the latest version of the knowledge.

1.  **Trigger via Web Interface**:
    *   Log in to the administrator interface, navigate to the "Knowledge Base Management" or "System Settings" page.
    *   Find and click the "Knowledge Base Indexing" or "Refresh Knowledge Base" button.
    *   The system will start scanning the configured knowledge base directories, processing new/modified files, and updating the vector database.
2.  **Trigger via API**:
    *   **Full Indexing**: `POST /api/v1/knowledge/index`

### 3.2 Automatic Indexing (Optional)

In some deployments, ZY SmartBI can be configured to automatically scan and index knowledge base directories periodically to keep the knowledge base up-to-date. This is typically achieved through background scheduled tasks. Please refer to the [System Configuration Guide](03_system_configuration.md) or operations manual for relevant configurations.

## 4. Validating Knowledge Base Effectiveness

After indexing is complete, you can verify that the knowledge base is working correctly in the following ways:

1.  **Test Queries**:
    *   Try asking ZY SmartBI a question that requires knowledge base content for an accurate answer. For example, if your knowledge base contains the calculation formula for a specific business metric, you can ask: "How is 'Customer Lifetime Value' calculated?"
    *   Observe whether ZY SmartBI's answer is accurate, complete, and references information from the knowledge base.
    *   **API Example**: `GET /api/v1/knowledge/search?q=<query_string>`
2.  **View Logs**:
    *   Check ZY SmartBI's operational logs, especially those of the RAG service. The logs may show detailed information about knowledge base retrieval, such as which document snippets were retrieved, similarity scores, etc.

## 5. Knowledge Base Maintenance

### 5.1 Clearing the Knowledge Base

If you wish to completely rebuild the knowledge base, you can perform a clear operation.
*   **Via Web Interface**: On the "Knowledge Base Management" page, there will typically be a "Clear Knowledge Base" button.
*   **Via API**: `POST /api/v1/knowledge/clear`
*   **Note**: This operation will delete all user-uploaded knowledge documents from the vector database, but it will not delete the source files you configured in the file system.

### 5.2 Deleting Individual Documents

The system generates unique document IDs based on file content. If needed, you can delete individual indexed documents by their ID.
*   **Via API**: `DELETE /api/v1/knowledge/documents/{doc_id}`
*   **Use Case**: This feature is very useful when you only want to remove a specific, no longer needed file, without re-indexing the entire directory.

## 6. Knowledge Base Content Optimization Suggestions

*   **Clear and Concise**: Knowledge base document content should be clear, concise, and unambiguous.
*   **Structured**: Whenever possible, use formats like Markdown to structure documents, making them easier for the system to parse and understand.
*   **Regular Updates**: Business rules and data definitions may change over time, so regularly update knowledge base content and re-index.
*   **Avoid Redundancy**: Avoid having a large amount of duplicate or outdated information in the knowledge base, as this can affect retrieval efficiency and accuracy.

## 7. Next Steps

Effective knowledge base management is key to enhancing ZY SmartBI's intelligence. For more information on system logs and troubleshooting, please refer to the operations-related technical documentation.