# ZY SmartBI Security and User Management Guide

This guide aims to instruct ZY SmartBI system administrators on how to effectively manage user accounts, roles, and permissions, and configure data security policies, including Row-Level Security (RLS) and Column-Level Security (CLS). Ensuring data security and compliance is central to ZY SmartBI's operation.

## 1. User Management

User management is the foundation for controlling who can access the ZY SmartBI system.

### 1.1 Creating New Users

1.  **Login to Admin Interface**: Log in to the ZY SmartBI web interface using your administrator account.
2.  **Navigate to User Management**: In the admin interface, find the "User Management" or "User List" entry.
3.  **Click "Add New User"**: Fill in the following information:
    *   **Username**: A unique identifier for the user.
    *   **Password**: Set an initial password for the user. It is recommended to force users to change their password after their first login.
    *   **Email** (Optional): Used for notifications or password recovery.
    *   **Status**: Enable/disable the user account.
4.  **Save User**: Click the save button to complete user creation.
    *   **API Example**: `POST /api/v1/auth/users`

### 1.2 Editing and Deleting Users

*   **Edit User**: Select the user to edit from the user list, modify their information (e.g., password, email, status), and then save.
    *   **API Example**: `PUT /api/v1/rbac/users/{user_id}`
*   **Delete User**: Select the user to delete from the user list. **Caution**: Deleting a user is an irreversible operation; please proceed with care.
    *   **API Example**: `DELETE /api/v1/rbac/users/{user_id}`

## 2. Role Management (RBAC - Role-Based Access Control)

Roles are collections of permissions. By assigning permissions to roles and then assigning roles to users, permission management can be simplified.

### 2.1 Creating New Roles

1.  **Navigate to Role Management**: In the admin interface, find the "Role Management" or "Roles and Permissions" entry.
2.  **Click "Create New Role"**:
    *   **Role Name**: Assign a descriptive name to the role (e.g., `Sales_Analyst`, `Marketing_Manager`, `HR_Viewer`).
    *   **Role Description** (Optional): Briefly describe the responsibilities and scope of permissions for this role.
3.  **Assign Permissions**:
    *   **Data Source Access**: Select which configured data sources this role can access.
    *   **Feature Permissions**: For example, whether this role is allowed to create reports, share insights, access specific modules of the admin backend, etc.
4.  **Save Role**: Click the save button.
    *   **API Example**: `POST /api/v1/rbac/roles`

### 2.2 Editing and Deleting Roles

*   **Edit Role**: Modify the role's name, description, or permissions.
    *   **API Example**: `PUT /api/v1/rbac/roles/{role_id}`
*   **Delete Role**: Delete roles that are no longer needed. **Caution**: Before deleting a role, ensure that no users are assigned to it, or reassign those users to other roles.
    *   **API Example**: `DELETE /api/v1/rbac/roles/{role_id}`

### 2.3 Assigning Roles to Users

1.  **Navigate to User Management**: Find the user to whom you want to assign roles.
2.  **Edit User**: In the user editing interface, find the "Roles" or "Assign Roles" section.
3.  **Select Role**: Choose one or more roles from the list of available roles to assign to the user.
4.  **Save**: Save the user changes.
    *   **API Example**: `POST /api/v1/rbac/user-roles` (assign), `DELETE /api/v1/rbac/user-roles` (remove)

## 3. Data Access Control (RLS & CLS)

ZY SmartBI supports fine-grained data access control through Row-Level Security (RLS) and Column-Level Security (CLS).

*   **Row-Level Security (RLS)**: Allows you to restrict a user's access to specific rows in a database table based on their identity. For example, a sales manager can only see sales data for their own team.
*   **Column-Level Security (CLS)**: Allows you to restrict a user's access to specific columns in a database table. For example, only users from the HR department can see employee salary information.

In the current version, the definition and application of RLS and CLS policies are advanced features, typically configured via the backend API during role creation. Administrators can define row filtering conditions or specify accessible column lists for specific data tables within the role permission configuration. When a user with that role queries data, the system automatically applies these security policies.

## 5. PII Data Masking

ZY SmartBI includes built-in PII (Personally Identifiable Information) masking functionality to protect sensitive data from exposure during transmission and processing, especially when interacting with external LLM services.

*   **Enable/Disable**: PII masking is typically controlled globally through system configuration (`PII_SCRUBBING_ENABLED` in the `.env` file).
*   **Configure Rules**: Administrators can configure PII identification rules in the system backend (e.g., defining patterns for email addresses, phone numbers, ID numbers via regular expressions). These rules can be dynamically loaded from the database.
    *   **API Example**: `POST /api/v1/settings/pii` (for updating PII patterns, if implemented)

## 6. Audit Logs

ZY SmartBI records critical user operations and system events, forming audit logs. This is essential for security auditing, problem tracing, and compliance requirements.

*   **View Audit Logs**: Administrators can access the "Audit Logs" module in the admin interface to view detailed records of user logins, data queries, configuration changes, etc.
    *   **API Example**: `GET /api/v1/audit-logs`
*   **Log Configuration**: Log levels and storage paths can be configured in the [System Configuration Guide](03_system_configuration.md).

## 7. Next Steps

*   **Knowledge Base Management**: To learn how to manage ZY SmartBI's knowledge base, refer to the [Knowledge Base Management Guide](06_knowledge_base_management.md).
*   **Daily Operations**: To understand system monitoring and troubleshooting, refer to [Monitoring, Alerting, and Logging](docs/technical/operations/01_monitoring.md) and [Common Troubleshooting](docs/technical/operations/03_troubleshooting.md).