# ZY SmartBI Data Source Management Guide

This guide provides detailed instructions on how administrators can manage data sources within ZY SmartBI, including adding, editing, testing connections, and importing metadata.

## 1. Overview of Data Source Management

Data sources are the foundation of ZY SmartBI, connecting the platform to your various business databases. Proper management of data sources ensures that users can access and analyze the correct and up-to-date data.

## 2. Accessing Data Source Management

1.  **Login**: Log in to the ZY SmartBI system with an administrator account.
2.  **Navigation**: In the left-side menu or top navigation bar, find and click on "Data Source Management".

## 3. Adding a New Data Source

1.  **Click "Add New Data Source"**: On the Data Source Management page, click the button to add a new data source.
2.  **Fill in Connection Information**:
    *   **Name**: A unique, descriptive name for your data source (e.g., `Sales_Database`, `ERP_System`).
    *   **Database Type**: Select the type of database from the dropdown list (e.g., `PostgreSQL`, `MySQL`, `SQL Server`, `Oracle`, `SQLite`).
    *   **Host**: The IP address or hostname of the database server.
    *   **Port**: The port number of the database server (default for PostgreSQL is 5432, MySQL is 3306).
    *   **Database Name**: The name of the specific database you want to connect to.
    *   **Username**: The username for connecting to the database.
    *   **Password**: The password for the specified username.
    *   **Description (Optional)**: A brief description of the data source, its purpose, or the data it contains.
3.  **Test Connection**: After filling in all the information, click the "Test Connection" button. The system will attempt to connect to the database using the provided credentials. A success message will appear if the connection is established, otherwise, an error message will indicate the problem.
4.  **Save Data Source**: If the connection test is successful, click the "Save" button to add the data source to ZY SmartBI.

## 4. Editing an Existing Data Source

1.  **Select Data Source**: On the Data Source Management page, find the data source you want to edit from the list.
2.  **Click "Edit"**: Click the "Edit" icon or button next to the data source entry.
3.  **Modify Information**: Update the necessary connection parameters or description.
4.  **Test and Save**: After making changes, it is highly recommended to click "Test Connection" again. If successful, click "Save" to apply the changes.

## 5. Deleting a Data Source

1.  **Select Data Source**: On the Data Source Management page, find the data source you want to delete from the list.
2.  **Click "Delete"**: Click the "Delete" icon or button next to the data source entry.
3.  **Confirm Deletion**: A confirmation dialog will appear. Confirm the deletion. **Note: Deleting a data source will also remove all associated metadata and potentially impact existing dashboards or queries that rely on it.**

## 6. Importing and Enriching Metadata

After adding or editing a data source, it is crucial to import and enrich its metadata so that ZY SmartBI can understand the database structure and provide accurate natural language to SQL conversion.

1.  **Navigate to Metadata Management**: From the Data Source Management page, or directly from the main menu, go to "Metadata Management".
2.  **Select Data Source**: Choose the data source whose metadata you want to manage from the dropdown list at the top of the page.
3.  **Import Metadata**: Click the "Import Data Source Metadata" button. This action will scan the selected database and import its table and column schemas into ZY SmartBI.
4.  **AI Auto-generate Metadata (Highly Recommended)**: After importing, click the "AI Auto-generate Metadata" button. The system will use its AI capabilities to analyze the imported schema and sample data, automatically generating business descriptions, synonyms, and usage examples for tables and columns. This significantly enhances the accuracy and relevance of natural language queries.
    *   **Review and Edit**: You can review the AI-generated descriptions and make manual edits if needed to ensure accuracy and alignment with your business terminology.

## 7. Next Steps

*   **System Configuration**: For general system settings, refer to the [System Configuration Guide](03_system_configuration.md).
*   **Security and User Management**: To manage user access and permissions to these data sources, refer to the [Security and User Management Guide](05_security_user_management.md).
*   **Knowledge Base Management**: To integrate external knowledge documents, refer to the [Knowledge Base Management Guide](06_knowledge_base_management.md).