# ZY SmartBI Installation and Deployment Guide

This guide provides detailed instructions on how to install and deploy ZY SmartBI from scratch in a server environment. Please follow the steps below to ensure a smooth deployment.

## 1. Environment and Software Preparation

### 1.1 System and Hardware Requirements

*   **Operating System**: Windows 10 or higher.
*   **Hardware**: Recommended 4-core CPU, 8GB RAM, 50GB available disk space.
*   **Network**: A stable internet connection is required to access LLM services.

### 1.2 Core Software Packages

You will need to prepare the installation packages for the following core software:
*   **PostgreSQL**: Latest version recommended (e.g., 17.6).
*   **Python**: Version 3.13.6 recommended.

You can download these packages from their official websites or use the provided cloud drive link. Please place the downloaded packages in the root directory of the release package.

## 2. Installation Steps

We provide a series of batch scripts (`.bat`) to simplify the installation process.

### Step 1: Install Core Components

*   Double-click `Install ZY AI Smart Business.bat` to install the core components.
*   Double-click `Install python.bat` to install the Python environment and dependencies required by ZY SmartBI.
*   **Important**: After installing PostgreSQL, run `services.msc` to open the Services Manager, find the `postgresql` service, and set its startup type to "Automatic".

### Step 2: Configure Environment Variables (`.env` file)

1.  In the project root directory, find the `.env.example` file, copy it, and rename it to `.env`.
2.  Open the `.env` file with a text editor and configure the following key information:
    *   **Database Connection**:
        ```env
        DB_USER=postgres
        DB_PASSWORD=ZYCBI2025 # Please change this to your PostgreSQL password
        DB_HOST=127.0.0.1
        DB_PORT=5432
        DB_NAME=chatbi_forge_dev
        ```
    *   **Administrator Account (created on first startup)**:
        ```env
        DEFAULT_ADMIN_USERNAME=admin
        DEFAULT_ADMIN_PASSWORD=admin1
        ```
    *   **Debug Login (Optional)**:
        ```env
        # Set to True to log in with any password, for development/testing environments only
        LOGIN_DEBUG=True 
        ```
    *   **LLM API Keys (at least one must be configured)**:
        ```env
        DEEPSEEK_API_KEY=your_deepseek_api_key_here
        DASHSCOPE_API_KEY=your_dashscope_api_key_here
        DASHSCOPE_API_BASE_URL=https://dashscope.aliyuncs.com/api/v1
        ```
    *   **Project Info File Path (Optional)**:
        ```env
        PROJECT_INFO_FILE_PATH=ZYchatBI_project_info.txt
        ```

### Step 3: Initialize Data

*   Double-click the `Initialize Data.bat` script.
*   This script will connect to the database you configured in the `.env` file, create the necessary table structures, and import sample data.

### Step 4: Start the Services

*   Double-click the `Run ZY chatBI.bat` script.
*   The service takes about 40 seconds to start. Once started, you can access the system through your browser.

## 3. Accessing the System

*   **User Login**: `http://127.0.0.1:8000/login`
*   **Chat Interface**: `http://127.0.0.1:8000/chat`
*   **Admin Interface**: `http://127.0.0.1:8000/admin/dashboard`

## 4. Next Steps

After deployment, please refer to the following guides for further configuration:
*   **Data Source Management**: [Data Source Management Guide](04_datasource_management.md)
*   **Users and Permissions**: [Security and User Management Guide](05_security_user_management.md)
*   **System Configuration**: [System Configuration Guide](03_system_configuration.md)