# ZY SmartBI Administrator Quick Start Guide

Welcome to the ZY SmartBI Administrator Guide! This guide is designed to help you quickly complete core administrative tasks after the system's initial startup, enabling business users to get started.

This guide assumes you have completed all installation and startup steps according to the [Installation and Deployment Guide](02_installation_guide.md).

## 1. First-time Login to the Admin Account

1.  **Access the System**: Open your browser and navigate to `http://127.0.0.1:8000/login`.
2.  **Log in with Default Credentials**:
    *   Username: `admin`
    *   Password: `admin1`
3.  After logging in, it is recommended that you immediately navigate to the user management module to change the default administrator's password.

## 2. Connect Your First Business Data Source

The core of ZY SmartBI is connecting to your enterprise data. Here are the quick steps to connect a data source:

1.  **Navigate to Data Source Management**: After logging in, find "Data Source Management" in the left-side menu or top navigation bar.
2.  **Add a Data Source**:
    *   Click "Add New Data Source".
    *   Fill in a unique name for the data source (e.g., `sales_dw`), select the database type (e.g., `POSTGRESQL`), and enter the connection parameters.
    *   Click "Test Connection" to verify that the configuration is correct.
    *   Save the data source.

## 3. Import and Enrich Metadata

Once the data source is connected, you need to help ZY SmartBI understand its data structure. Navigate to the "Metadata Management" page.

1.  **Select Data Source**: At the top of the page, select the data source you just added from the dropdown menu.
2.  **Import Metadata**: Click the "Import Data Source Metadata" button. This action will read the table and column information from the database and record it in the ZY SmartBI system.
3.  **AI-Generate Descriptions (Recommended)**: After a successful import, click the "AI Auto-generate Metadata" button. The system will use AI to analyze the table structure and sample data to automatically generate business descriptions, synonyms, etc., for tables and columns. This will significantly improve the accuracy of the subsequent natural language to SQL conversion.

## 4. Create Your First User and Role

1.  **Create a Role**:
    *   Navigate to "Role & Permission Management".
    *   Create a new role, for example, `Sales_Analyst`.
    *   Assign access permissions for the newly created data source (`sales_dw`) to this role.
2.  **Create a User**:
    *   Navigate to "User Management".
    *   Create a new user and assign them to the `Sales_Analyst` role.

## 5. Next Steps

Congratulations! You have successfully completed the core configuration of ZY SmartBI. The business user you created can now log in with their account and start asking questions and performing analysis on the `sales_dw` data source.

To learn more about advanced administrative functions, please refer to:
*   [System Configuration Guide](03_system_configuration.md)
*   [Data Source Management Guide](04_datasource_management.md)
*   [Security and User Management Guide](05_security_user_management.md)
