# ZY SmartBI Docker 部署操作指南

本指南将帮助您在 Docker 环境中部署 ZY SmartBI 应用，包括 PostgreSQL 数据库、后端服务和前端静态文件服务。

## 目录结构

请确保您的目录结构如下所示：

```
/
├── docker/
│   ├── docker-compose.yml
│   ├── Dockerfile.app
│   └── backend.env
├── backend_binary/
│   └── ZY_SmartBI
├── frontend/
│   └── build/
├── scripts/
└── req.txt
```

## 操作步骤

1.  **进入 `docker` 目录：**
    打开终端或命令提示符，导航到 `/docker` 目录：
    ```bash
    cd /path/to/your/project/docker
    ```
    (请将 `/path/to/your/project/` 替换为您的实际项目路径)

2.  **构建 Docker 镜像：**
    执行以下命令来构建您的应用镜像：
    ```bash
    docker compose build
    ```

3.  **启动所有服务：**
    执行以下命令在后台启动 PostgreSQL 数据库和您的应用服务：
    ```bash
    docker compose up -d
    ```

4.  **初始化数据库 (重要！)：**
    首次启动服务后，您需要手动执行数据库初始化脚本。
    首先，找到 `app` 容器的名称或 ID：
    ```bash
    docker ps
    ```
    您会看到类似 `release-docker-app-1` 的容器名称（具体名称可能因您的项目名和 compose 文件而异）。

    然后，进入容器并执行初始化脚本（可以不用，目前可以自动初始化）：
    ```bash
    # 进入 app 容器
    docker exec -it <app_container_name_or_id> bash

    # 在容器内部执行以下命令
    # 这些脚本的路径是相对于容器内的 /app 目录
    python /app/scripts/initialize_db_schema.py
    python /app/scripts/initialize_sample_data.py

    # 退出容器
    exit
    ```

## 访问应用

*   **应用访问：** 在浏览器中访问 `http://localhost:8000/`。如果您的后端二进制正确配置了静态文件服务，您应该能看到前端界面。
*   **后端 API：** 后端 API 也在 `http://localhost:8000/` 上。

## 重要注意事项
*   **`backend.env` 配置：** 请务必手动修改 `/docker/backend.env` 文件中的 `DB_PASSWORD` 和所有 LLM API 密钥，以确保安全和应用正常运行。
