# ZY SmartBI Docker Deployment Guide

This guide will help you deploy the ZY SmartBI application in a Docker environment, including the PostgreSQL database, backend service, and frontend static file serving.

## Directory Structure

Please ensure your directory has the following structure:

```
/
├── docker/
│   ├── docker-compose.yml
│   ├── Dockerfile.app
│   └── backend.env
├── backend_binary/
│   └── ZY_SmartBI
├── frontend/
│   └── build/
├── scripts/
└── req.txt
```

## Operation Steps

1.  **Navigate to the `docker` directory:**
    Open your terminal or command prompt and navigate to the `/docker` directory:
    ```bash
    cd /path/to/your/project/docker
    ```
    (Replace `/path/to/your/project/` with your actual project path)

2.  **Build Docker Images:**
    Execute the following command to build your application image:
    ```bash
    docker compose build
    ```

3.  **Start All Services:**
    Execute the following command to start the PostgreSQL database and your application service in the background:
    ```bash
    docker compose up -d
    ```

4.  **Initialize Database (Important!):**
    After the services start for the first time, you might need to manually run the database initialization scripts (Optional, currently automatically initialized).
    First, find the name or ID of your `app` container:
    ```bash
    docker ps
    ```
    You will see a container name similar to `release-docker-app-1` (the exact name might vary based on your project name and compose file).

    Then, enter the container and execute the initialization scripts:
    ```bash
    # Enter the app container
    docker exec -it <app_container_name_or_id> bash

    # Execute the following commands inside the container
    # The paths to these scripts are relative to the /app directory inside the container
    python /app/scripts/initialize_db_schema.py
    python /app/scripts/initialize_sample_data.py

    # Exit the container
    exit
    ```

## Accessing the Application

*   **Application Access:** Open your web browser and navigate to `http://localhost:8000/`. If your backend binary is correctly configured to serve static files, you should see the frontend interface.
*   **Backend API:** The backend API is also available at `http://localhost:8000/`.

## Important Notes

*   **`backend.env` Configuration:** Make sure to manually modify the `DB_PASSWORD` and all LLM API keys in the `/docker/backend.env` file to ensure security and proper application functionality.