# 使用一个包含 Python 的基础镜像
FROM ubuntu:22.04

# 设置工作目录
WORKDIR /app

# 安装 Python 和 pip
RUN apt-get update && apt-get install -y python3 python3-pip && rm -rf /var/lib/apt/lists/*
RUN update-alternatives --install /usr/bin/python python /usr/bin/python3 1

# 复制并安装初始化脚本所需的 Python 依赖
# 注意：现在 requirements.txt 在容器内的 /app/req.txt 路径下
COPY req.txt .
RUN pip install -r req.txt

# 暴露应用端口
EXPOSE 8000

# 默认命令，将被 docker-compose.yml 中的 command 覆盖
CMD ["/bin/bash"]